/*******************************************************************************
 * Copyright (c) 2017, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.features;

import com.pushtechnology.diffusion.client.session.SessionException;

/**
 * Exception used to report that an operation has failed
 * because the receiver could not process the supplied data.
 *
 * @author DiffusionData Limited
 * @since 6.0
 */
public final class IncompatibleDatatypeException extends SessionException {

    private static final long serialVersionUID = -3735779723026197453L;

    /**
     * Constructor.
     *
     * @param message the exception message
     */
    public IncompatibleDatatypeException(String message) {
        super(message);
    }
}
