/*******************************************************************************
 * Copyright (c) 2017, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.features;

import java.util.List;

import com.pushtechnology.diffusion.client.types.ErrorReport;

/**
 * Exception used to report a filter expression is invalid.
 *
 * @author DiffusionData Limited
 * @since 6.0
 */
public final class InvalidFilterException extends ErrorReportsException {

    private static final long serialVersionUID = 2217213017964500721L;

    /**
     * Constructor.
     */
    public InvalidFilterException(String message, List<ErrorReport> reports) {
        super(message, reports);
    }
}