/*******************************************************************************
 * Copyright (c) 2014, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.features.control.topics;

/**
 * The reason for failure to add a topic.
 *
 * @author DiffusionData Limited
 * @since 5.0
 */
public enum TopicAddFailReason {

    /**
     * A topic already exists with exactly the same specification.
     */
    EXISTS,

    /**
     * A topic already exists with the same path but a different specification.
     */
    EXISTS_MISMATCH,

    /**
     * The supplied topic path is invalid.
     */
    INVALID_NAME,

    /**
     * Some aspect of the topic specification failed validation.
     */
    INVALID_DETAILS,

    /**
     * The client was denied permission to add a topic of the specified type at
     * the given point in the topic hierarchy.
     */
    PERMISSIONS_FAILURE,

    /**
     * An unexpected error occurred whilst attempting to create the topic. See
     * the server log for more details.
     */
    UNEXPECTED_ERROR,

    /**
     * Adding the topic failed because the cluster was repartitioning due to a
     * server starting, stopping, or failing. The operation can be retried.
     *
     * @since 6.0
     */
    CLUSTER_REPARTITION,

    /**
     * Adding the topic failed because of a licence limit.
     *
     * @since 6.0
     */
    EXCEEDED_LICENSE_LIMIT,

    /**
     * Adding the topic failed because a topic is already bound to the specified
     * path but the caller does not have the rights to manage it.
     * <P>
     * This can be because the topic is being managed by a component with
     * exclusive control over the topic, such as fan-out and thus the caller
     * will not be able to update or remove the topic.
     * <P>
     * If the caller has suitable permissions then it could still subscribe to
     * the topic, but the topic's specification may be different from that
     * requested.
     *
     * @since 6.0
     */
    EXISTS_INCOMPATIBLE;

}
