/*******************************************************************************
 * Copyright (c) 2014, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.callbacks;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Callback interface that provides responses from the server, together with
 * an application supplied context object.
 * <P>
 * This interface and its extensions are alternatives to the {@link Callback}
 * interface hierarchy that allow the application to associate an arbitrary
 * context object with each call. Any suitable application object can be
 * provided as the context. It will be passed on to the corresponding callback
 * methods, allowing requests and responses to be correlated. The context object
 * is optional (it may be {@code null}).
 * <P>
 * In all other respects {@link Callback} and {@link ContextCallback} behave
 * identically.
 *
 * @author DiffusionData Limited
 * @since 5.1
 * @param <C> context object type
 * @see Callback
 * @see ContextStream
 *
 * @deprecated since 6.7
 *             <p>
 *             Methods that use contextual callbacks are deprecated and will be
 *             removed in a future release. Use CompletableFuture variant
 *             instead.
 */
@Deprecated
public interface ContextCallback<C> {

    /**
     * Notification of a contextual error related to this callback. This is
     * analogous to an exception being raised. Situations in which
     * {@code onError} is called include the session being closed, a
     * communication timeout, or a problem with the provided parameters. No
     * further calls will be made to this callback for the call context.
     *
     * @param context the context object supplied when making the call. May be
     *        {@code null}.
     * @param errorReason a value representing the error; this can be one of
     *        constants defined in {@link ErrorReason}, or a feature-specific
     *        reason
     */
    void onError(C context, ErrorReason errorReason);

    /**
     * Abstract default callback.
     * <P>
     * This simply logs onError calls at debug level. This should be overridden
     * to perform more specific error handling.
     *
     * @param <C> context object type
     */
    abstract class Default<C> implements ContextCallback<C> {

        private static final Logger LOG =
            LoggerFactory.getLogger(Default.class);

        @Override
        public void onError(C context, ErrorReason errorReason) {
            LOG.warn("{} error, reason={}, context={}", this, errorReason, context);
        }
    }
}
