/*******************************************************************************
 * Copyright (c) 2018, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/

package com.pushtechnology.diffusion.client.features;

import com.pushtechnology.diffusion.client.session.SessionException;

/**
 * An operation could not be performed because the topic is managed by a
 * component (such as fan-out) that prohibits updates from the caller.
 *
 * @author DiffusionData Limited
 * @since 6.2
 */
public final class IncompatibleTopicStateException extends SessionException {
    private static final long serialVersionUID = 4873459827146350040L;

    /**
     * Constructor.
     *
     * @param message the exception message
     */
    public IncompatibleTopicStateException(String message) {
        super(message);
    }
}
