/*******************************************************************************
 * Copyright (c) 2014, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.features;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

import com.pushtechnology.diffusion.client.session.SessionClosedException;

/**
 * A reference to a registered handler.
 * <P>
 * Such a handler reference is provided whenever a handler with a server side
 * presence is registered.
 *
 * @author DiffusionData Limited
 * @since 5.0
 *
 * @deprecated since 6.7
 *             <p>
 *             This interface is only used by deprecated methods and will be
 *             removed in a future release.
 */
@Deprecated
public interface RegisteredHandler {

    /**
     * Request that the handler is unregistered from the server.
     * <P>
     * After the handler is unregistered, the handler's {@code onClose} method
     * will be called. If the handler has already been unregistered, this method
     * will have no effect.
     *
     * @return a CompletableFuture that completes when a response is received
     *         from the server.
     *
     *         <p>
     *         If the task completes successfully, the CompletableFuture result
     *         will be null. The result type is any rather than Void to
     *         provide forward compatibility with future iterations of this API
     *         that may provide a non-null result with a more specific result
     *         type.
     *
     *         <p>
     *         Otherwise, the CompletableFuture will complete exceptionally with
     *         a {@link CompletionException}. Common reasons for failure, listed
     *         by the exception reported as the
     *         {@link CompletionException#getCause() cause}, include:
     *
     *         <ul>
     *         <li>{@link SessionClosedException} &ndash; if the session is
     *         closed.
     *         </ul>
     */
    CompletableFuture<?> close();
}