/*******************************************************************************
 * Copyright (c) 2019, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/

package com.pushtechnology.diffusion.client.features.control.topics.views;

import java.util.Set;

/**
 * Description of a topic view that has been created.
 *
 * @author DiffusionData Limited
 * @since 6.3
 * @see TopicViews
 */
public interface TopicView {
    /**
     * The name of the topic view.
     *
     * @return the name of the topic view
     */
    String getName();

    /**
     * The <a href="./TopicViews.html#view-specification">specification</a> of
     * the topic view.
     *
     * @return the specification of the topic view
     */
    String getSpecification();

    /**
     * The roles used by the view when evaluating permissions.
     *
     * @return the roles used by the view when evaluating permissions
     */
    Set<String> getRoles();
}
