/*******************************************************************************
 * Copyright (c) 2022, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.session;

/**
 * The session operation failed due to a permissions failure. Repeating
 * the operation with the same permissions is likely to fail.
 *
 * @author DiffusionData Limited
 * @since 6.8
 */
public class PermissionsException extends SessionSecurityException {

    private static final long serialVersionUID = -9093928610820121093L;

    /**
     * Constructor.
     */
    public PermissionsException() {
        this(
            "The session operation failed due to a violated permissions constraint");
    }

    /**
     * @see SessionSecurityException#SessionSecurityException(String)
     *
     * @param description the exception message
     */
    public PermissionsException(String description) {
        super(description);
    }

    /**
     * @see SessionSecurityException#SessionSecurityException(String, Throwable)
     *
     * @param description the exception message
     * @param cause of the exception
     */
    public PermissionsException(String description, Throwable cause) {
        super(description, cause);
    }
}
