/*******************************************************************************
 * Copyright (c) 2014, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.session;

/**
 * The session operation failed due to a security constraint. Repeating
 * the operation with the same security credentials is likely to fail.
 *
 * @author DiffusionData Limited
 * @since 5.0
 */
public class SessionSecurityException extends SessionException {

    private static final long serialVersionUID = -4306256298762792308L;

    /**
     * Constructor.
     */
    public SessionSecurityException() {
        this(
            "The session operation failed due to a violated security constraint");
    }

    /**
     * @see RuntimeException#RuntimeException(String)
     *
     * @param description the exception message
     * @since 6.0
     */
    public SessionSecurityException(String description) {
        super(description);
    }

    /**
     * @see RuntimeException#RuntimeException(String, Throwable)
     *
     * @param description the exception message
     * @param cause of the exception
     * @since 6.6
     */
    public SessionSecurityException(String description, Throwable cause) {
        super(description, cause);
    }
}
