/*******************************************************************************
 * Copyright (c) 2014, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.session.proxy;

import com.pushtechnology.diffusion.client.Diffusion;

/**
 * Factory for {@link HTTPProxyAuthentication proxy authentication} instances.
 * <P>
 * This factory allows common proxy authentication schemes to be used when
 * connecting a {@link com.pushtechnology.diffusion.client.session.Session
 * session} to a server.
 * <P>
 * An instance of this factory can be obtained using
 * {@link Diffusion#proxyAuthentication()}.
 *
 * @author DiffusionData Limited
 * @since 5.1
 */
public interface ProxyAuthenticationFactory {

    /**
     * Provides an implementation of Basic proxy authentication.
     *
     * @param username specifies the username to be used when authenticating a
     *        connection to a proxy server using Basic authentication
     *
     * @param password the password associated with the provided username to
     *        authenticate a connection to the proxy server
     *
     * @return an instance of a Basic Proxy Authentication scheme
     */
    HTTPProxyAuthentication basic(String username, String password);
}
