/*******************************************************************************
 * Copyright (c) 2014, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.topics;

/**
 * A selector that selects a single topic path.
 *
 * @author DiffusionData Limited
 * @since 5.0
 */
public interface TopicPathSelector extends TopicSelector {

    /**
     * Return the associated topic path. The result will be in a normalised
     * form, with no leading or trailing '/''.
     *
     * @return The topic path.
     */
    String getPath();
}
