/*******************************************************************************
 * Copyright (c) 2017, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.datatype.recordv2.schema;

/**
 * Indicates a problem that has occurred when parsing a {@link Schema}.
 *
 * @author DiffusionData Limited
 * @since 6.0
 */
public final class SchemaParseException extends Exception {

    private static final long serialVersionUID = 5647643603705628250L;

    /**
     * Constructor.
     *
     * @param message the error message
     * @param cause the cause of the exception
     */
    public SchemaParseException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor.
     *
     * @param message the error message
     */
    public SchemaParseException(String message) {
        super(message);
    }

}
