/*******************************************************************************
 * Copyright (c) 2017, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/

package com.pushtechnology.diffusion.client.features;

import static com.pushtechnology.diffusion.client.callbacks.ErrorReason.CLUSTER_REPARTITION;

/**
 * Indicates a cluster operation failed because partition ownership changed
 * during processing.
 * <p>
 * Replicated configuration and replicated topic data is stored in partitions.
 * Each server in a cluster owns a share of the partitions. Partitions can be
 * migrated to different servers in the cluster when servers are started,
 * stopped, or fail. During partition migration, cluster operations may fail.
 * <p>
 * This is a transient error that occurs while the cluster is recovering from
 * failure. The session can retry the operation.
 *
 * @author DiffusionData Limited
 * @since 6.0
 */
public final class ClusterRepartitionException extends ClusterRoutingException {

    private static final long serialVersionUID = 6202769306842759203L;

    /**
     * Constructor.
     */
    public ClusterRepartitionException() {
        super(CLUSTER_REPARTITION.getDescription());
    }

    /**
     * Constructor.
     *
     * @param message the exception message
     */
    public ClusterRepartitionException(String message) {
        super(message);
    }

    /**
     * Constructor.
     *
     * @param message the exception message
     * @param cause the cause
     */
    public ClusterRepartitionException(String message, Throwable cause) {
        super(message, cause);
    }
}
