/*******************************************************************************
 * Copyright (c) 2017, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.features;

import com.pushtechnology.diffusion.client.session.SessionException;

/**
 * Thrown to indicate a handler could not be registered because it conflicts
 * with an existing handler.
 *
 * @author DiffusionData Limited
 * @since 6.0
 */
public class HandlerConflictException extends SessionException {

    private static final long serialVersionUID = -4410781980849001296L;

    /**
     * Constructor.
     *
     * @param message the exception message
     */
    public HandlerConflictException(String message) {
        super(message);
    }
}
