/*******************************************************************************
 * Copyright (c) 2018, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/

package com.pushtechnology.diffusion.client.features;

import com.pushtechnology.diffusion.client.session.SessionException;

/**
 * Exception used to report an operation was performed with an invalid
 * {@link UpdateStream update stream}.
 *
 * @author DiffusionData Limited
 * @since 6.2
 */
public final class InvalidUpdateStreamException extends SessionException {
    private static final long serialVersionUID = 7356400780107090724L;

    /**
     * Constructor.
     *
     * @param message the exception message
     */
    public InvalidUpdateStreamException(String message) {
        super(message);
    }

    /**
     * Constructor.
     *
     * @param cause the exception cause
     */
    public InvalidUpdateStreamException(Throwable cause) {
        super(cause);
    }
}
