/*******************************************************************************
 * Copyright (c) 2014, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.session;

/**
 * This is the base interface for features that may be added directly to a
 * client {@link Session session}.
 * <P>
 * A feature is a unit of functionality that is available to a client session.
 *
 * @author DiffusionData Limited
 * @since 5.0
 */
public interface Feature {

    /**
     * This returns the session that the feature applies to.
     *
     * @return the associated session
     */
    Session getSession();

}
