/*******************************************************************************
 * Copyright (c) 2025 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.topics;

/**
 * A topic selection that represents either a subscription (selection) or an
 * unsubscription (deselection).
 *
 * @author DiffusionData Limited
 * @since 6.12
 */
public interface TopicSelection {

    /**
     * Returns the selection type.
     */
    Type getType();

    /**
     * Returns the topic selector for the selection or deselection.
     *
     * @return the topic selector
     */
    TopicSelector getSelector();

    /**
     * Topic selector type.
     */
    enum Type {

        /**
         * Represents selection of topics (i.e. subscription).
         */
        SELECT,

        /**
         * Represents deselection of topics (i.e. unsubscription).
         */
        DESELECT;
    }

}
