/*******************************************************************************
 * Copyright (c) 2016, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.datatype;

/**
 * Binary delta type.
 *
 * <p>
 * {@link DataType} implementations that support binary deltas by
 * returning a {@link DeltaType} implementation as the result of
 * {@link DataType#deltaType(Class) deltaType(BinaryDelta.class)}. Two values of
 * such a data type can be {@link DeltaType#diff(Object, Object) diffed} to
 * create a binary delta. The binary delta can later be
 * {@link DeltaType#apply(Object, Object) applied} to the first value to
 * calculate the second value.
 *
 * @author DiffusionData Limited
 * @since 5.7
 */
public interface BinaryDelta {

    /**
     * Returns whether the two values used to create this instance are
     * different. It is equivalent to {@code !DeltaType.noChange().equals(this)}
     * .
     *
     * @return true if this delta has an effect
     */
    boolean hasChanges();

    /**
     * @return the number of bytes required to
     *         {@link DeltaType#writeDelta(Object, java.io.OutputStream)
     *         serialize} the delta
     */
    int length();
}
