/*******************************************************************************
 * Copyright (c) 2016, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.datatype;

/**
 * Unchecked exception indicating that binary data could not be parsed as a
 * value.
 *
 * @author DiffusionData Limited
 * @since 5.7
 * @see DataType#validate(Object)
 */
public final class InvalidDataException extends RuntimeException {

    private static final long serialVersionUID = -6862099728494652227L;

    /**
     * Constructor.
     *
     * @param cause chained exception
     */
    public InvalidDataException(Exception cause) {
        super(cause);
    }

    /**
     * Constructor.
     *
     * @param message detail message
     */
    public InvalidDataException(String message) {
        super(message);
    }
}
