/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractMatrix;
import com.xxdb.data.BasicDouble;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.List;

public class BasicDoubleMatrix
extends AbstractMatrix {
    private double[] values;

    public BasicDoubleMatrix(int rows, int columns) {
        super(rows, columns);
        this.values = new double[rows * columns];
    }

    public BasicDoubleMatrix(int rows, int columns, List<double[]> listOfArrays) throws Exception {
        super(rows, columns);
        this.values = new double[rows * columns];
        if (listOfArrays == null || listOfArrays.size() != columns) {
            throw new Exception("input list of arrays does not have " + columns + " columns");
        }
        for (int i = 0; i < columns; ++i) {
            double[] array = listOfArrays.get(i);
            if (array == null || array.length != rows) {
                throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
            }
            System.arraycopy(array, 0, this.values, i * rows, rows);
        }
    }

    public BasicDoubleMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setDouble(int row, int column, double value) {
        this.values[this.getIndex((int)row, (int)column)] = value;
    }

    public double getDouble(int row, int column) {
        return this.values[this.getIndex(row, column)];
    }

    @Override
    public boolean isNull(int row, int column) {
        return this.values[this.getIndex(row, column)] == -1.7976931348623157E308;
    }

    @Override
    public void setNull(int row, int column) {
        this.values[this.getIndex((int)row, (int)column)] = -1.7976931348623157E308;
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicDouble(this.values[this.getIndex(row, column)]);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.FLOATING;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DOUBLE;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDouble.class;
    }

    @Override
    protected void readMatrixFromInputStream(int rows, int columns, ExtendedDataInput in) throws IOException {
        int size = rows * columns;
        this.values = new double[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readDouble();
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        for (double value : this.values) {
            out.writeDouble(value);
        }
    }
}

