/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractMatrix;
import com.xxdb.data.BasicFloat;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.List;

public class BasicFloatMatrix
extends AbstractMatrix {
    private float[] values;

    public BasicFloatMatrix(int rows, int columns) {
        super(rows, columns);
        this.values = new float[rows * columns];
    }

    public BasicFloatMatrix(int rows, int columns, List<float[]> listOfArrays) throws Exception {
        super(rows, columns);
        this.values = new float[rows * columns];
        if (listOfArrays == null || listOfArrays.size() != columns) {
            throw new Exception("input list of arrays does not have " + columns + " columns");
        }
        for (int i = 0; i < columns; ++i) {
            float[] array = listOfArrays.get(i);
            if (array == null || array.length != rows) {
                throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
            }
            System.arraycopy(array, 0, this.values, i * rows, rows);
        }
    }

    public BasicFloatMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setFloat(int row, int column, float value) {
        this.values[this.getIndex((int)row, (int)column)] = value;
    }

    public float getFloat(int row, int column) {
        return this.values[this.getIndex(row, column)];
    }

    @Override
    public boolean isNull(int row, int column) {
        return this.values[this.getIndex(row, column)] == -3.4028235E38f;
    }

    @Override
    public void setNull(int row, int column) {
        this.values[this.getIndex((int)row, (int)column)] = -3.4028235E38f;
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicFloat(this.values[this.getIndex(row, column)]);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.FLOATING;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_FLOAT;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicFloat.class;
    }

    @Override
    protected void readMatrixFromInputStream(int rows, int columns, ExtendedDataInput in) throws IOException {
        int size = rows * columns;
        this.values = new float[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readFloat();
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        for (float value : this.values) {
            out.writeFloat(value);
        }
    }
}

