/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicInt;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.List;

public class BasicIntVector
extends AbstractVector {
    private int[] values;

    public BasicIntVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicIntVector(List<Integer> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i);
            }
        }
    }

    public BasicIntVector(int[] array) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = (int[])array.clone();
    }

    protected BasicIntVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new int[size];
    }

    protected BasicIntVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new int[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readInt();
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicInt(this.values[index]);
    }

    public int getInt(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index] = value.getNumber().intValue();
    }

    public void setInt(int index, int value) {
        this.values[index] = value;
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == Integer.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = Integer.MIN_VALUE;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_INT;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicInt.class;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeIntArray(this.values);
    }
}

