/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicLongVector;
import com.xxdb.data.BasicNanoTimestamp;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;

public class BasicNanoTimestampVector
extends BasicLongVector {
    public BasicNanoTimestampVector(int size) {
        super(size);
    }

    public BasicNanoTimestampVector(List<Long> list) {
        super(list);
    }

    public BasicNanoTimestampVector(long[] array) {
        super(array);
    }

    protected BasicNanoTimestampVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicNanoTimestampVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_NANOTIMESTAMP;
    }

    @Override
    public Scalar get(int index) {
        return new BasicNanoTimestamp(this.getLong(index));
    }

    public LocalDateTime getNanoTimestamp(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseNanoTimestamp(this.getLong(index));
    }

    public void setNanoTimestamp(int index, LocalDateTime dt) {
        this.setLong(index, Utils.countNanoseconds(dt));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicNanoTimestamp.class;
    }
}

