/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.io;

import com.xxdb.io.AbstractExtendedDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianDataOutputStream
extends AbstractExtendedDataOutputStream {
    public LittleEndianDataOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.write(0xFF & v);
        this.out.write(0xFF & v >> 8);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.write(0xFF & v);
        this.out.write(0xFF & v >> 8);
        this.out.write(0xFF & v >> 16);
        this.out.write(0xFF & v >> 24);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.out.write((int)(0xFFL & v));
        this.out.write((int)(0xFFL & v >> 8));
        this.out.write((int)(0xFFL & v >> 16));
        this.out.write((int)(0xFFL & v >> 24));
        this.out.write((int)(0xFFL & v >> 32));
        this.out.write((int)(0xFFL & v >> 40));
        this.out.write((int)(0xFFL & v >> 48));
        this.out.write((int)(0xFFL & v >> 56));
    }

    @Override
    public void writeIntArray(int[] A, int startIdx, int len) throws IOException {
        if (this.buf == null) {
            this.buf = new byte[4096];
        }
        int end = startIdx + len;
        int pos = 0;
        for (int i = startIdx; i < end; ++i) {
            int v = A[i];
            if (pos + 4 >= 4096) {
                this.out.write(this.buf, 0, pos);
                pos = 0;
            }
            this.buf[pos++] = (byte)(0xFF & v);
            this.buf[pos++] = (byte)(0xFF & v >> 8);
            this.buf[pos++] = (byte)(0xFF & v >> 16);
            this.buf[pos++] = (byte)(0xFF & v >> 24);
        }
        if (pos > 0) {
            this.out.write(this.buf, 0, pos);
        }
    }

    @Override
    public void writeShortArray(short[] A, int startIdx, int len) throws IOException {
        if (this.buf == null) {
            this.buf = new byte[4096];
        }
        int end = startIdx + len;
        int pos = 0;
        for (int i = startIdx; i < end; ++i) {
            short v = A[i];
            if (pos + 2 >= 4096) {
                this.out.write(this.buf, 0, pos);
                pos = 0;
            }
            this.buf[pos++] = (byte)(0xFF & v);
            this.buf[pos++] = (byte)(0xFF & v >> 8);
        }
        if (pos > 0) {
            this.out.write(this.buf, 0, pos);
        }
    }

    @Override
    public void writeLongArray(long[] A, int startIdx, int len) throws IOException {
        if (this.buf == null) {
            this.buf = new byte[4096];
        }
        int end = startIdx + len;
        int pos = 0;
        for (int i = startIdx; i < end; ++i) {
            long v = A[i];
            if (pos + 8 >= 4096) {
                this.out.write(this.buf, 0, pos);
                pos = 0;
            }
            this.buf[pos++] = (byte)(0xFFL & v);
            this.buf[pos++] = (byte)(0xFFL & v >> 8);
            this.buf[pos++] = (byte)(0xFFL & v >> 16);
            this.buf[pos++] = (byte)(0xFFL & v >> 24);
            this.buf[pos++] = (byte)(0xFFL & v >> 32);
            this.buf[pos++] = (byte)(0xFFL & v >> 40);
            this.buf[pos++] = (byte)(0xFFL & v >> 48);
            this.buf[pos++] = (byte)(0xFFL & v >> 56);
        }
        if (pos > 0) {
            this.out.write(this.buf, 0, pos);
        }
    }
}

