/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.streaming.client.AbstractClient;
import com.xxdb.streaming.client.IMessage;
import com.xxdb.streaming.client.MessageHandler;
import java.io.IOException;
import java.net.SocketException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class ThreadedClient
extends AbstractClient {
    public ThreadedClient() throws SocketException {
        this(8849);
    }

    public ThreadedClient(int subscribePort) throws SocketException {
        super(subscribePort);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler, long offset) throws IOException {
        BlockingQueue<List<IMessage>> queue = this.subscribeInternal(host, port, tableName, offset);
        new HandlerLopper(queue, handler).start();
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler) throws IOException {
        this.subscribe(host, port, tableName, handler, -1L);
    }

    void unsubscribe(String host, int port, String tableName) throws IOException {
        this.unsubscribeInternal(host, port, tableName);
    }

    class HandlerLopper
    extends Thread {
        BlockingQueue<List<IMessage>> queue;
        MessageHandler handler;

        HandlerLopper(BlockingQueue<List<IMessage>> queue, MessageHandler handler) {
            this.queue = queue;
            this.handler = handler;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block3: while (true) {
                        List<IMessage> msgs = this.queue.take();
                        Iterator<IMessage> iterator = msgs.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block3;
                            IMessage msg = iterator.next();
                            this.handler.doEvent(msg);
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

