/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractMatrix;
import com.xxdb.data.BasicString;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.List;

public class BasicStringMatrix
extends AbstractMatrix {
    private String[] values;
    private boolean isSymbol;

    public BasicStringMatrix(int rows, int columns) {
        super(rows, columns);
        this.values = new String[rows * columns];
        this.isSymbol = true;
    }

    public BasicStringMatrix(int rows, int columns, List<String[]> list) throws Exception {
        super(rows, columns);
        this.values = new String[rows * columns];
        if (list == null || list.size() != columns) {
            throw new Exception("input list of arrays does not have " + columns + " columns");
        }
        for (int i = 0; i < columns; ++i) {
            String[] array = list.get(i);
            if (array == null || array.length != rows) {
                throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
            }
            System.arraycopy(array, 0, this.values, i * rows, rows);
        }
        this.isSymbol = true;
    }

    public BasicStringMatrix(ExtendedDataInput in) throws IOException {
        super(in);
        this.isSymbol = true;
    }

    public void setString(int row, int column, String value) {
        this.values[this.getIndex((int)row, (int)column)] = value;
    }

    public String getString(int row, int column) {
        return this.values[this.getIndex(row, column)];
    }

    @Override
    public boolean isNull(int row, int column) {
        return this.values[this.getIndex(row, column)].isEmpty();
    }

    @Override
    public void setNull(int row, int column) {
        this.values[this.getIndex((int)row, (int)column)] = "";
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicString(this.values[this.getIndex(row, column)]);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LITERAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return this.isSymbol ? Entity.DATA_TYPE.DT_SYMBOL : Entity.DATA_TYPE.DT_STRING;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicString.class;
    }

    @Override
    protected void readMatrixFromInputStream(int rows, int columns, ExtendedDataInput in) throws IOException {
        int size = rows * columns;
        this.values = new String[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readString();
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        for (String value : this.values) {
            out.writeString(value);
        }
    }
}

