/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.text.DecimalFormat;
import java.time.temporal.Temporal;

public class BasicDouble
extends AbstractScalar
implements Comparable<BasicDouble> {
    private static final DecimalFormat df1 = new DecimalFormat("0.######");
    private static final DecimalFormat df2 = new DecimalFormat("0.######E0");
    private double value;

    public BasicDouble(double value) {
        this.value = value;
    }

    public BasicDouble(ExtendedDataInput in) throws IOException {
        this.value = in.readDouble();
    }

    public double getDouble() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == -1.7976931348623157E308;
    }

    @Override
    public void setNull() {
        this.value = -1.7976931348623157E308;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.FLOATING;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DOUBLE;
    }

    @Override
    public Number getNumber() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.value);
    }

    @Override
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            return String.valueOf(this.value);
        }
        double absVal = Math.abs(this.value);
        if (absVal > 0.0 && absVal <= 1.0E-6 || absVal >= 1000000.0) {
            return df2.format(this.value);
        }
        return df1.format(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicDouble) || o == null) {
            return false;
        }
        return this.value == ((BasicDouble)o).value;
    }

    public int hashCode() {
        return new Double(this.value).hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        return -1;
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeDouble(this.value);
    }

    @Override
    public int compareTo(BasicDouble o) {
        return Double.compare(this.value, o.value);
    }
}

