/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.time.temporal.Temporal;

public class BasicInt
extends AbstractScalar
implements Comparable<BasicInt> {
    private int value;

    public BasicInt(int value) {
        this.value = value;
    }

    public BasicInt(ExtendedDataInput in) throws IOException {
        this.value = in.readInt();
    }

    public int getInt() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == Integer.MIN_VALUE;
    }

    @Override
    public void setNull() {
        this.value = Integer.MIN_VALUE;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_INT;
    }

    @Override
    public Number getNumber() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return new Integer(this.value);
    }

    @Override
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicInt) || o == null) {
            return false;
        }
        return this.value == ((BasicInt)o).value;
    }

    public int hashCode() {
        return new Integer(this.value).hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        if (this.value >= 0) {
            return this.value % buckets;
        }
        if (this.value == Integer.MIN_VALUE) {
            return -1;
        }
        return (int)((0x100000000L + (long)this.value) % (long)buckets);
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeInt(this.value);
    }

    @Override
    public int compareTo(BasicInt o) {
        return Integer.compare(this.value, o.value);
    }
}

