/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicInt128;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.Long2;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BasicInt128Vector
extends AbstractVector {
    protected Long2[] values;

    public BasicInt128Vector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicInt128Vector(List<Long2> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new Long2[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i);
            }
        }
    }

    public BasicInt128Vector(Long2[] array) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = (Long2[])array.clone();
    }

    protected BasicInt128Vector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new Long2[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = new Long2(0L, 0L);
        }
    }

    protected BasicInt128Vector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        ByteOrder bo;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new Long2[size];
        int totalBytes = size * 16;
        boolean littleEndian = in.isLittleEndian();
        ByteOrder byteOrder = bo = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (int off = 0; off < totalBytes; off += len) {
            int i;
            len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = off / 16;
            int end = len / 16;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            if (littleEndian) {
                for (i = 0; i < end; ++i) {
                    long low = byteBuffer.getLong(i * 16);
                    long high = byteBuffer.getLong(i * 16 + 8);
                    this.values[i + start] = new Long2(high, low);
                }
                continue;
            }
            for (i = 0; i < end; ++i) {
                long high = byteBuffer.getLong(i * 16);
                long low = byteBuffer.getLong(i * 16 + 8);
                this.values[i + start] = new Long2(high, low);
            }
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicInt128(this.values[index].high, this.values[index].low);
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index].high = ((BasicInt128)value).getMostSignicantBits();
        this.values[index].low = ((BasicInt128)value).getLeastSignicantBits();
    }

    public void setInt128(int index, long highValue, long lowValue) {
        this.values[index].high = highValue;
        this.values[index].low = lowValue;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return this.values[index].hashBucket(buckets);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index].isNull();
    }

    @Override
    public void setNull(int index) {
        this.values[index].setNull();
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.BINARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_INT128;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicInt128.class;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeLong2Array(this.values);
    }
}

