/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.time.temporal.Temporal;

public class BasicString
extends AbstractScalar
implements Comparable<BasicString> {
    private String value;

    public BasicString(String value) {
        this.value = value;
    }

    public BasicString(ExtendedDataInput in) throws IOException {
        this.value = in.readString();
    }

    @Override
    public String getString() {
        return this.value;
    }

    protected void setString(String value) {
        this.value = value;
    }

    @Override
    public boolean isNull() {
        return this.value.isEmpty();
    }

    @Override
    public void setNull() {
        this.value = "";
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LITERAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_STRING;
    }

    @Override
    public Number getNumber() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicString) || o == null) {
            return false;
        }
        return this.value.equals(((BasicString)o).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        return BasicString.hashBucket(this.value, buckets);
    }

    public static int hashBucket(String str, int buckets) {
        int length = str.length();
        int bytes = 0;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++bytes;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                bytes += 2;
                continue;
            }
            bytes += 3;
        }
        int h = bytes;
        if (bytes == length) {
            int length4 = bytes / 4;
            for (int i = 0; i < length4; ++i) {
                int i4 = i * 4;
                int k = (str.charAt(i4) & 0xFF) + ((str.charAt(i4 + 1) & 0xFF) << 8) + ((str.charAt(i4 + 2) & 0xFF) << 16) + ((str.charAt(i4 + 3) & 0xFF) << 24);
                k *= 1540483477;
                k ^= k >>> 24;
                h *= 1540483477;
                h ^= (k *= 1540483477);
            }
            switch (bytes % 4) {
                case 3: {
                    h ^= (str.charAt((bytes & 0xFFFFFFFC) + 2) & 0xFF) << 16;
                }
                case 2: {
                    h ^= (str.charAt((bytes & 0xFFFFFFFC) + 1) & 0xFF) << 8;
                }
                case 1: {
                    h ^= str.charAt(bytes & 0xFFFFFFFC) & 0xFF;
                    h *= 1540483477;
                }
            }
            h ^= h >>> 13;
            h *= 1540483477;
            h ^= h >>> 15;
        } else {
            int k = 0;
            int cursor = 0;
            for (int i = 0; i < length; ++i) {
                char c = str.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    k += c << 8 * cursor++;
                } else if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                    k += (0xC0 | 0x1F & c >> 6) << 8 * cursor++;
                    if (cursor == 4) {
                        k *= 1540483477;
                        k ^= k >>> 24;
                        h *= 1540483477;
                        h ^= (k *= 1540483477);
                        k = 0;
                        cursor = 0;
                    }
                    k += (0x80 | 0x3F & c) << 8 * cursor++;
                } else {
                    k += (0xE0 | 0xF & c >> 12) << 8 * cursor++;
                    if (cursor == 4) {
                        k *= 1540483477;
                        k ^= k >>> 24;
                        h *= 1540483477;
                        h ^= (k *= 1540483477);
                        k = 0;
                        cursor = 0;
                    }
                    k += (0x80 | 0x3F & c >> 6) << 8 * cursor++;
                    if (cursor == 4) {
                        k *= 1540483477;
                        k ^= k >>> 24;
                        h *= 1540483477;
                        h ^= (k *= 1540483477);
                        k = 0;
                        cursor = 0;
                    }
                    k += (0x80 | 0x3F & c) << 8 * cursor++;
                }
                if (cursor != 4) continue;
                k *= 1540483477;
                k ^= k >>> 24;
                h *= 1540483477;
                h ^= (k *= 1540483477);
                k = 0;
                cursor = 0;
            }
            if (cursor > 0) {
                h ^= k;
                h *= 1540483477;
            }
            h ^= h >>> 13;
            h *= 1540483477;
            h ^= h >>> 15;
        }
        if (h >= 0) {
            return h % buckets;
        }
        return (int)((0x100000000L + (long)h) % (long)buckets);
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeString(this.value);
    }

    @Override
    public int compareTo(BasicString o) {
        return this.value.compareTo(o.value);
    }
}

