/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.data.Vector;
import com.xxdb.streaming.client.AbstractClient;
import com.xxdb.streaming.client.IMessage;
import com.xxdb.streaming.client.MessageHandler;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.LockSupport;

public class ThreadPooledClient
extends AbstractClient {
    private static int CORES = Runtime.getRuntime().availableProcessors();
    private ExecutorService threadPool;
    private HashMap<String, QueueHandlerBinder> queueHandlers = new HashMap();

    public ThreadPooledClient() throws SocketException {
        this("", 8849, CORES);
    }

    public ThreadPooledClient(int subscribePort, int threadCount) throws SocketException {
        this("", subscribePort, threadCount);
    }

    public ThreadPooledClient(String subscribeHost, int subscribePort, int threadCount) throws SocketException {
        super(subscribeHost, subscribePort);
        this.threadPool = Executors.newFixedThreadPool(threadCount);
        new Thread(){
            private LinkedList<IMessage> backlog = new LinkedList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fillBacklog() {
                boolean filled = false;
                HashMap hashMap = ThreadPooledClient.this.queueHandlers;
                synchronized (hashMap) {
                    Set keySet = ThreadPooledClient.this.queueHandlers.keySet();
                    for (String topic : keySet) {
                        List messages = (List)((QueueHandlerBinder)ThreadPooledClient.this.queueHandlers.get(topic)).queue.poll();
                        if (messages == null) continue;
                        this.backlog.addAll(messages);
                        filled = true;
                    }
                }
                return filled;
            }

            private void refill() {
                int count = 200;
                while (!this.fillBacklog()) {
                    if (count <= 100) {
                        if (count > 0) {
                            Thread.yield();
                        } else {
                            LockSupport.park();
                        }
                    }
                    --count;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    IMessage msg;
                    if ((msg = this.backlog.poll()) != null) {
                        QueueHandlerBinder binder;
                        HashMap hashMap = ThreadPooledClient.this.queueHandlers;
                        synchronized (hashMap) {
                            binder = (QueueHandlerBinder)ThreadPooledClient.this.queueHandlers.get(msg.getTopic());
                        }
                        ThreadPooledClient.this.threadPool.execute(new HandlerRunner(binder.handler, msg));
                        continue;
                    }
                    this.refill();
                }
            }
        }.start();
    }

    @Override
    protected boolean doReconnect(AbstractClient.Site site) {
        this.threadPool.shutdownNow();
        try {
            Thread.sleep(1000L);
            this.subscribe(site.host, site.port, site.tableName, site.actionName, site.handler, site.msgId + 1L, true, site.filter, site.allowExistTopic);
            System.out.println("Successfully reconnected and subscribed " + site.host + ":" + site.port + ":" + site.tableName);
            return true;
        }
        catch (Exception ex) {
            System.out.println("Unable to subscribe table. Will try again after 1 seconds.");
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect, Vector filter, boolean allowExistTopic) throws IOException {
        BlockingQueue<List<IMessage>> queue = this.subscribeInternal(host, port, tableName, actionName, handler, offset, reconnect, filter, allowExistTopic);
        HashMap<String, QueueHandlerBinder> hashMap = this.queueHandlers;
        synchronized (hashMap) {
            this.queueHandlers.put((String)this.tableNameToTrueTopic.get(host + ":" + port + ":" + tableName), new QueueHandlerBinder(queue, handler));
        }
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, boolean reconnect) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, reconnect, null, false);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset, Vector filter) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, false, filter, false);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, long offset) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, offset, false);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, -1L);
    }

    public void subscribe(String host, int port, String tableName, String actionName, MessageHandler handler, boolean reconnect) throws IOException {
        this.subscribe(host, port, tableName, actionName, handler, -1L, reconnect);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler) throws IOException {
        this.subscribe(host, port, tableName, "javaStreamingApi", handler, -1L);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler, boolean reconnect) throws IOException {
        this.subscribe(host, port, tableName, "javaStreamingApi", handler, -1L, reconnect);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler, long offset) throws IOException {
        this.subscribe(host, port, tableName, "javaStreamingApi", handler, offset);
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler, long offset, boolean reconnect) throws IOException {
        this.subscribe(host, port, tableName, "javaStreamingApi", handler, offset, reconnect);
    }

    public void unsubscribe(String host, int port, String tableName, String actionName) throws IOException {
        this.unsubscribeInternal(host, port, tableName, actionName);
    }

    public void unsubscribe(String host, int port, String tableName) throws IOException {
        this.unsubscribeInternal(host, port, tableName);
    }

    class HandlerRunner
    implements Runnable {
        MessageHandler handler;
        IMessage message;

        HandlerRunner(MessageHandler handler, IMessage message) {
            this.handler = handler;
            this.message = message;
        }

        @Override
        public void run() {
            this.handler.doEvent(this.message);
        }
    }

    private class QueueHandlerBinder {
        private BlockingQueue<List<IMessage>> queue;
        private MessageHandler handler;

        public QueueHandlerBinder(BlockingQueue<List<IMessage>> queue, MessageHandler handler) {
            this.queue = queue;
            this.handler = handler;
        }
    }
}

