/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import com.xxdb.RSAUtils;
import com.xxdb.ServerExceptionUtils;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.Entity;
import com.xxdb.data.EntityFactory;
import com.xxdb.io.BigEndianDataInputStream;
import com.xxdb.io.BigEndianDataOutputStream;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.LittleEndianDataInputStream;
import com.xxdb.io.LittleEndianDataOutputStream;
import com.xxdb.io.ProgressListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;

public class DBConnection {
    private static final int MAX_FORM_VALUE = Entity.DATA_FORM.values().length - 1;
    private static final int MAX_TYPE_VALUE = Entity.DATA_TYPE.values().length - 1;
    private static final int DEFAULT_PRIORITY = 4;
    private static final int DEFAULT_PARALLELISM = 2;
    private ReentrantLock mutex;
    private String sessionID = "";
    private Socket socket;
    private boolean remoteLittleEndian;
    private ExtendedDataOutput out;
    private ExtendedDataInput in;
    private EntityFactory factory = new BasicEntityFactory();
    private String hostName;
    private int port;
    private String mainHostName;
    private int mainPort;
    private String userId;
    private String password;
    private String initialScript = null;
    private boolean encrypted;
    private String controllerHost = null;
    private int controllerPort;
    private boolean highAvailability;
    private String[] highAvailabilitySites = null;
    private boolean HAReconnect = false;
    private int connTimeout = 0;

    public DBConnection() {
        this.mutex = new ReentrantLock();
    }

    public boolean isBusy() {
        if (!this.mutex.tryLock()) {
            return true;
        }
        this.mutex.unlock();
        return false;
    }

    public boolean connect(String hostName, int port) throws IOException {
        return this.connect(hostName, port, "", "", null, false, null);
    }

    public boolean connect(String hostName, int port, int timeout) throws IOException {
        this.connTimeout = timeout;
        return this.connect(hostName, port, "", "", null, false, null);
    }

    public boolean connect(String hostName, int port, String initialScript) throws IOException {
        return this.connect(hostName, port, "", "", initialScript, false, null);
    }

    public boolean connect(String hostName, int port, String initialScript, boolean highAvailability) throws IOException {
        return this.connect(hostName, port, "", "", initialScript, highAvailability, null);
    }

    public boolean connect(String hostName, int port, boolean highAvailability) throws IOException {
        return this.connect(hostName, port, "", "", null, highAvailability, null);
    }

    public boolean connect(String hostName, int port, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, "", "", null, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String initialScript, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, "", "", initialScript, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String userId, String password) throws IOException {
        return this.connect(hostName, port, userId, password, null, false, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, boolean highAvailability) throws IOException {
        return this.connect(hostName, port, userId, password, null, highAvailability, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, userId, password, null, true, highAvailabilitySites);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, false, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean highAvailability) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, highAvailability, null);
    }

    public boolean connect(String hostName, int port, String userId, String password, String initialScript, String[] highAvailabilitySites) throws IOException {
        return this.connect(hostName, port, userId, password, initialScript, true, highAvailabilitySites);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(String hostName, int port, String userId, String password, String initialScript, boolean highAvailability, String[] highAvailabilitySites) throws IOException {
        this.mutex.lock();
        try {
            if (!this.sessionID.isEmpty()) {
                this.mutex.unlock();
                boolean bl = true;
                return bl;
            }
            this.hostName = hostName;
            this.mainHostName = hostName;
            this.port = port;
            this.mainPort = port;
            this.userId = userId;
            this.password = password;
            this.encrypted = true;
            this.initialScript = initialScript;
            this.highAvailability = highAvailability;
            this.highAvailabilitySites = highAvailabilitySites;
            if (highAvailabilitySites != null) {
                for (String site : highAvailabilitySites) {
                    String[] HASite = site.split(":");
                    if (HASite.length == 2) continue;
                    throw new IllegalArgumentException("The site '" + site + "' is invalid.");
                }
            }
            assert (highAvailabilitySites == null || highAvailability);
            boolean bl = this.connect();
            return bl;
        }
        finally {
            this.mutex.unlock();
        }
    }

    private boolean connect() throws IOException {
        try {
            this.socket = new Socket(this.hostName, this.port);
        }
        catch (ConnectException ex) {
            if (this.HAReconnect) {
                return false;
            }
            if (this.switchToRandomAvailableSite()) {
                return true;
            }
            throw ex;
        }
        if (this.connTimeout > 0) {
            this.socket.setSoTimeout(this.connTimeout);
        }
        this.socket.setKeepAlive(true);
        this.socket.setTcpNoDelay(true);
        this.out = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        LittleEndianDataInputStream input = new LittleEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        String body = "connect\n";
        this.out.writeBytes("API 0 ");
        this.out.writeBytes(String.valueOf(body.length()));
        this.out.writeByte(10);
        this.out.writeBytes(body);
        this.out.flush();
        String line = input.readLine();
        int endPos = line.indexOf(32);
        if (endPos <= 0) {
            this.close();
            return this.switchToRandomAvailableSite();
        }
        this.sessionID = line.substring(0, endPos);
        int startPos = endPos + 1;
        if ((endPos = line.indexOf(32, startPos)) != line.length() - 2) {
            this.close();
            return this.switchToRandomAvailableSite();
        }
        if (line.charAt(endPos + 1) == '0') {
            this.remoteLittleEndian = false;
            this.out = new BigEndianDataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        } else {
            this.remoteLittleEndian = true;
        }
        ExtendedDataInput extendedDataInput = this.in = this.remoteLittleEndian ? new LittleEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream())) : new BigEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        if (!this.userId.isEmpty() && !this.password.isEmpty()) {
            this.login();
        }
        if (this.initialScript != null && this.initialScript.length() > 0) {
            this.run(this.initialScript);
        }
        if (this.highAvailability && this.highAvailabilitySites == null) {
            try {
                this.controllerHost = ((BasicString)this.run("rpc(getControllerAlias(), getNodeHost)")).getString();
                this.controllerPort = ((BasicInt)this.run("rpc(getControllerAlias(), getNodePort)")).getInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String userId, String password, boolean enableEncryption) throws IOException {
        this.mutex.lock();
        try {
            this.userId = userId;
            this.password = password;
            this.encrypted = enableEncryption;
            this.login();
        }
        finally {
            this.mutex.unlock();
        }
    }

    private void login() throws IOException {
        ArrayList<Entity> args = new ArrayList<Entity>();
        if (this.encrypted) {
            BasicString keyCode = (BasicString)this.run("getDynamicPublicKey", new ArrayList<Entity>());
            PublicKey key = RSAUtils.getPublicKey(keyCode.getString());
            byte[] usr = RSAUtils.encryptByPublicKey(this.userId.getBytes(), key);
            byte[] pass = RSAUtils.encryptByPublicKey(this.password.getBytes(), key);
            args.add(new BasicString(Base64.getMimeEncoder().encodeToString(usr)));
            args.add(new BasicString(Base64.getMimeEncoder().encodeToString(pass)));
            args.add(new BasicBoolean(true));
        } else {
            args.add(new BasicString(this.userId));
            args.add(new BasicString(this.password));
        }
        this.run("login", args);
    }

    public boolean getRemoteLittleEndian() {
        return this.remoteLittleEndian;
    }

    private boolean switchToRandomAvailableSite() throws IOException {
        if (!this.highAvailability) {
            return false;
        }
        int tryCount = 0;
        while (true) {
            this.HAReconnect = true;
            if (this.highAvailabilitySites != null) {
                if (tryCount < 3) {
                    this.hostName = this.mainHostName;
                    this.port = this.mainPort;
                } else {
                    int rnd = new Random().nextInt(this.highAvailabilitySites.length);
                    String[] site = this.highAvailabilitySites[rnd].split(":");
                    this.hostName = site[0];
                    this.port = new Integer(site[1]);
                }
                ++tryCount;
            } else {
                if (this.controllerHost == null) {
                    return false;
                }
                DBConnection tmp = new DBConnection();
                tmp.connect(this.controllerHost, this.controllerPort);
                BasicStringVector availableSites = (BasicStringVector)tmp.run("getClusterLiveDataNodes(false)");
                tmp.close();
                int size = availableSites.rows();
                if (size <= 0) {
                    return false;
                }
                String[] site = availableSites.getString(0).split(":");
                this.hostName = site[0];
                this.port = new Integer(site[1]);
            }
            try {
                System.out.println("Trying to reconnect to " + this.hostName + ":" + this.port);
                if (this.connect()) {
                    this.HAReconnect = false;
                    System.out.println("Successfully reconnected to " + this.hostName + ":" + this.port);
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
            }
        }
    }

    private NotLeaderStatus handleNotLeaderException(Exception ex, String function) {
        String errMsg = ex.getMessage();
        if (ServerExceptionUtils.isNotLeader(errMsg).booleanValue()) {
            String newLeaderString = ServerExceptionUtils.newLeader(errMsg);
            String[] newLeader = newLeaderString.split(":");
            String newHostName = newLeader[0];
            int newPort = new Integer(newLeader[1]);
            if (this.hostName.equals(newHostName) && this.port == newPort) {
                System.out.println("Got NotLeader exception. Waiting for new leader.");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return NotLeaderStatus.WAIT;
            }
            this.hostName = newHostName;
            this.port = newPort;
            try {
                System.out.println("Got NotLeader exception. Switching to " + this.hostName + ":" + this.port);
                if (this.connect()) {
                    return NotLeaderStatus.NEW_LEADER;
                }
                return NotLeaderStatus.CONN_FAIL;
            }
            catch (IOException e) {
                return NotLeaderStatus.CONN_FAIL;
            }
        }
        return NotLeaderStatus.OTHER_EXCEPTION;
    }

    public Entity tryRun(String script) throws IOException {
        return this.tryRun(script, 4, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity tryRun(String script, int priority, int parallelism) throws IOException {
        if (!this.mutex.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(script, (ProgressListener)null, priority, parallelism);
            return entity;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public Entity run(String script) throws IOException {
        return this.run(script, (ProgressListener)null, 4, 2);
    }

    public Entity run(String script, int priority) throws IOException {
        return this.run(script, (ProgressListener)null, priority, 2);
    }

    public Entity run(String script, int priority, int parallelism) throws IOException {
        return this.run(script, (ProgressListener)null, priority, parallelism);
    }

    public Entity run(String script, ProgressListener listener) throws IOException {
        return this.run(script, listener, 4, 2);
    }

    /*
     * Exception decompiling
     */
    public Entity run(String script, ProgressListener listener, int priority, int parallelism) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK], 21[UNCONDITIONALDOLOOP], 2[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Entity tryRun(String function, List<Entity> arguments) throws IOException {
        return this.tryRun(function, arguments, 4, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity tryRun(String function, List<Entity> arguments, int priority, int parallelism) throws IOException {
        if (!this.mutex.tryLock()) {
            return null;
        }
        try {
            Entity entity = this.run(function, arguments, priority, parallelism);
            return entity;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public Entity run(String function, List<Entity> arguments) throws IOException {
        return this.run(function, arguments, 4, 2);
    }

    public Entity run(String function, List<Entity> arguments, int priority) throws IOException {
        return this.run(function, arguments, priority, 2);
    }

    /*
     * Exception decompiling
     */
    public Entity run(String function, List<Entity> arguments, int priority, int parallelism) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 22[UNCONDITIONALDOLOOP], 14[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void tryUpload(Map<String, Entity> variableObjectMap) throws IOException {
        if (!this.mutex.tryLock()) {
            throw new IOException("The connection is in use.");
        }
        try {
            this.upload(variableObjectMap);
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(Map<String, Entity> variableObjectMap) throws IOException {
        block22: {
            if (variableObjectMap == null || variableObjectMap.isEmpty()) {
                return;
            }
            this.mutex.lock();
            try {
                String msg;
                boolean reconnect = false;
                if (this.socket == null || !this.socket.isConnected() || this.socket.isClosed()) {
                    if (this.sessionID.isEmpty()) {
                        throw new IOException("Database connection is not established yet.");
                    }
                    reconnect = true;
                    this.socket = new Socket(this.hostName, this.port);
                    this.socket.setKeepAlive(true);
                    this.socket.setTcpNoDelay(true);
                    this.out = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                    this.in = this.remoteLittleEndian ? new LittleEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream())) : new BigEndianDataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                }
                ArrayList<Entity> objects = new ArrayList<Entity>();
                String body = "variable\n";
                for (String key : variableObjectMap.keySet()) {
                    if (!this.isVariableCandidate(key)) {
                        throw new IllegalArgumentException("'" + key + "' is not a good variable name.");
                    }
                    body = body + key + ",";
                    objects.add(variableObjectMap.get(key));
                }
                body = body.substring(0, body.length() - 1);
                body = body + "\n" + objects.size() + "\n";
                body = body + (this.remoteLittleEndian ? "1" : "0");
                try {
                    this.out.writeBytes("API " + this.sessionID + " ");
                    this.out.writeBytes(String.valueOf(body.length()));
                    this.out.writeByte(10);
                    this.out.writeBytes(body);
                    for (int i = 0; i < objects.size(); ++i) {
                        ((Entity)objects.get(i)).write(this.out);
                    }
                    this.out.flush();
                }
                catch (IOException ex) {
                    if (reconnect) {
                        this.socket = null;
                        throw ex;
                    }
                    try {
                        this.socket = new Socket(this.hostName, this.port);
                        this.socket.setKeepAlive(true);
                        this.socket.setTcpNoDelay(true);
                        this.out = new LittleEndianDataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                        this.out.writeBytes("API " + this.sessionID + " ");
                        this.out.writeBytes(String.valueOf(body.length()));
                        this.out.writeByte(10);
                        this.out.writeBytes(body);
                        for (int i = 0; i < objects.size(); ++i) {
                            ((Entity)objects.get(i)).write(this.out);
                        }
                        this.out.flush();
                        reconnect = true;
                    }
                    catch (Exception e) {
                        this.socket = null;
                        throw e;
                    }
                }
                String[] headers = this.in.readLine().split(" ");
                if (headers.length != 3) {
                    this.socket = null;
                    throw new IOException("Received invalid header.");
                }
                if (reconnect) {
                    this.sessionID = headers[0];
                }
                if (!(msg = this.in.readLine()).equals("OK")) {
                    throw new IOException(msg);
                }
            }
            catch (Exception ex) {
                if (this.socket != null || !this.highAvailability) {
                    throw ex;
                }
                if (this.switchToRandomAvailableSite()) {
                    this.mutex.unlock();
                    this.upload(variableObjectMap);
                    break block22;
                }
                throw ex;
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    public void close() {
        this.mutex.lock();
        try {
            if (this.socket != null) {
                this.socket.close();
                this.sessionID = "";
                this.socket = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.mutex.unlock();
        }
    }

    private boolean isVariableCandidate(String word) {
        char cur = word.charAt(0);
        if (!(cur >= 'a' && cur <= 'z' || cur >= 'A' && cur <= 'Z')) {
            return false;
        }
        for (int i = 1; i < word.length(); ++i) {
            cur = word.charAt(i);
            if (cur >= 'a' && cur <= 'z' || cur >= 'A' && cur <= 'Z' || cur >= '0' && cur <= '9' || cur == '_') continue;
            return false;
        }
        return true;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    private static enum NotLeaderStatus {
        NEW_LEADER,
        WAIT,
        CONN_FAIL,
        OTHER_EXCEPTION;

    }
}

