/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.List;

public class BasicBooleanVector
extends AbstractVector {
    private byte[] values;

    public BasicBooleanVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicBooleanVector(List<Byte> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i);
            }
        }
    }

    public BasicBooleanVector(byte[] array) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = (byte[])array.clone();
    }

    protected BasicBooleanVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new byte[size];
    }

    protected BasicBooleanVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new byte[size];
        for (int off = 0; off < size; off += len) {
            len = Math.min(4096, size - off);
            in.readFully(this.values, off, len);
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicBoolean(this.values[index]);
    }

    public boolean getBoolean(int index) {
        return this.values[index] != 0;
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index] = value.isNull() ? -128 : value.getNumber().byteValue();
    }

    public void setBoolean(int index, boolean value) {
        this.values[index] = value ? (byte)1 : 0;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicBooleanVector v = (BasicBooleanVector)vector;
        int newSize = this.rows() + v.rows();
        byte[] newValue = new byte[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicBooleanVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == -128;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = -128;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LOGICAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_BOOL;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicBoolean.class;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.write(this.values);
    }
}

