/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicSecond;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.util.List;

public class BasicSecondVector
extends BasicIntVector {
    public BasicSecondVector(int size) {
        super(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicSecondVector(List<Integer> list) {
        super(list);
    }

    public BasicSecondVector(int[] array) {
        super(array);
    }

    protected BasicSecondVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicSecondVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_SECOND;
    }

    @Override
    public Scalar get(int index) {
        return new BasicSecond(this.getInt(index));
    }

    public LocalTime getSecond(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseSecond(this.getInt(index));
    }

    public void setSecond(int index, LocalTime time) {
        this.setInt(index, Utils.countSeconds(time));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicSecond.class;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicSecondVector v = (BasicSecondVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicSecondVector(newValue);
    }
}

