/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.route.TableRouter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class IntegralValuePartitionedTableRouter
implements TableRouter {
    private Map<Long, List<String>> map;

    IntegralValuePartitionedTableRouter(AbstractVector values, BasicAnyVector locations) {
        if (values.getDataCategory() != Entity.DATA_CATEGORY.INTEGRAL) {
            throw new RuntimeException("expect a vector of integrals");
        }
        ArrayList<Long> longs = new ArrayList<Long>();
        for (int i = 0; i < values.rows(); ++i) {
            try {
                longs.add(values.get(i).getNumber().longValue());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        this.initialize(longs, locations);
    }

    private void initialize(List<Long> longs, BasicAnyVector locations) {
        boolean isScalar;
        if (locations.rows() <= 0) {
            throw new RuntimeException("requires at least one location");
        }
        if (locations.getEntity(0).getDataType() != Entity.DATA_TYPE.DT_STRING) {
            throw new RuntimeException("location must be a string");
        }
        if (longs.size() != locations.rows()) {
            throw new RuntimeException("expect # locations == # values");
        }
        this.map = new HashMap<Long, List<String>>();
        boolean bl = isScalar = locations.getEntity(0).getDataForm() == Entity.DATA_FORM.DF_SCALAR;
        if (isScalar) {
            for (int i = 0; i < locations.rows(); ++i) {
                BasicString location = (BasicString)locations.get(i);
                long val = longs.get(i);
                this.map.put(val, Arrays.asList(location.getString()));
            }
        } else {
            for (int i = 0; i < locations.rows(); ++i) {
                BasicStringVector locationVector = (BasicStringVector)locations.getEntity(i);
                long val = longs.get(i);
                this.map.put(val, new ArrayList());
                for (int j = 0; j < locationVector.rows(); ++j) {
                    this.map.get(val).add(locationVector.getString(j));
                }
            }
        }
    }

    @Override
    public String route(Scalar partitionColumn) {
        if (partitionColumn.getDataCategory() != Entity.DATA_CATEGORY.INTEGRAL) {
            throw new RuntimeException("invalid column category type" + partitionColumn.getDataCategory().name() + ", expect Integral category.");
        }
        try {
            long longVal = partitionColumn.getNumber().longValue();
            List<String> locations = this.map.get(longVal);
            if (locations == null) {
                throw new RuntimeException(partitionColumn.getNumber().longValue() + " does not match any partitioning values!");
            }
            return locations.get(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

