/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.time.temporal.Temporal;

public class BasicLong
extends AbstractScalar
implements Comparable<BasicLong> {
    private long value;

    public BasicLong(long value) {
        this.value = value;
    }

    public BasicLong(ExtendedDataInput in) throws IOException {
        this.value = in.readLong();
    }

    public long getLong() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == Long.MIN_VALUE;
    }

    @Override
    public void setNull() {
        this.value = Long.MIN_VALUE;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_LONG;
    }

    @Override
    public Number getNumber() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return new Long(this.value);
    }

    @Override
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicLong) || o == null) {
            return false;
        }
        return this.value == ((BasicLong)o).value;
    }

    public int hashCode() {
        return new Long(this.value).hashCode();
    }

    @Override
    public int hashBucket(int buckets) {
        if (this.value >= 0L) {
            return (int)(this.value % (long)buckets);
        }
        if (this.value == Long.MIN_VALUE) {
            return -1;
        }
        return (int)((Long.MAX_VALUE % (long)buckets + 2L + (Long.MAX_VALUE + this.value) % (long)buckets) % (long)buckets);
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return this.getString();
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    public int compareTo(BasicLong o) {
        return Long.compare(this.value, o.value);
    }
}

