/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.SymbolBase;
import com.xxdb.data.SymbolBaseCollection;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.List;

public class BasicStringVector
extends AbstractVector {
    private String[] values;
    private boolean isSymbol;
    private boolean isBlob = false;

    public BasicStringVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size, false);
    }

    public BasicStringVector(List<String> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i);
            }
        }
        this.isSymbol = false;
    }

    public BasicStringVector(List<String> list, boolean blob) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i);
            }
        }
        this.isSymbol = false;
        this.isBlob = blob;
    }

    public BasicStringVector(String[] array) {
        this(array, false, true);
    }

    public BasicStringVector(String[] array, boolean blob) {
        this(array, blob, true);
    }

    protected BasicStringVector(String[] array, boolean blob, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (String[])array.clone() : array;
        this.isSymbol = false;
        this.isBlob = blob;
    }

    protected BasicStringVector(Entity.DATA_FORM df, int size, boolean isSymbol) {
        super(df);
        this.values = new String[size];
        this.isSymbol = isSymbol;
    }

    protected BasicStringVector(Entity.DATA_FORM df, int size, boolean isSymbol, boolean isBlob) {
        super(df);
        this.values = new String[size];
        this.isBlob = isBlob;
        this.isSymbol = isSymbol;
    }

    protected BasicStringVector(Entity.DATA_FORM df, ExtendedDataInput in, boolean isSymbol, boolean blob) throws IOException {
        super(df);
        this.isBlob = blob;
        this.isSymbol = isSymbol;
        int rows = in.readInt();
        int columns = in.readInt();
        int size = rows * columns;
        this.values = new String[size];
        if (!blob) {
            if (isSymbol) {
                SymbolBase symbase = new SymbolBase(in);
                for (int i = 0; i < size; ++i) {
                    this.values[i] = symbase.getSymbol(in.readInt());
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    this.values[i] = in.readString();
                }
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.values[i] = in.readBlob();
            }
        }
    }

    protected BasicStringVector(Entity.DATA_FORM df, ExtendedDataInput in, boolean blob, SymbolBaseCollection collection) throws IOException {
        super(df);
        this.isBlob = blob;
        int rows = in.readInt();
        int columns = in.readInt();
        int size = rows * columns;
        this.values = new String[size];
        if (!blob) {
            if (collection != null) {
                SymbolBase symbase = collection.add(in);
                for (int i = 0; i < size; ++i) {
                    this.values[i] = symbase.getSymbol(in.readInt());
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    this.values[i] = in.readString();
                }
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.values[i] = in.readBlob();
            }
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicString(this.values[index]);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        String[] sub = new String[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicStringVector(sub, false, false);
    }

    public String getString(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index] = value.getString();
    }

    public void setString(int index, String value) {
        this.values[index] = value;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return BasicString.hashBucket(this.values[index], buckets);
    }

    @Override
    public Vector combine(Vector vector) {
        BasicStringVector v = (BasicStringVector)vector;
        int newSize = this.rows() + v.rows();
        String[] newValue = new String[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicStringVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == null || this.values[index].isEmpty();
    }

    @Override
    public void setNull(int index) {
        this.values[index] = "";
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LITERAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        if (this.isBlob) {
            return Entity.DATA_TYPE.DT_BLOB;
        }
        return this.isSymbol ? Entity.DATA_TYPE.DT_SYMBOL : Entity.DATA_TYPE.DT_STRING;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicString.class;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        if (!this.isBlob) {
            for (String str : this.values) {
                out.writeString(str);
            }
        } else {
            for (String str : this.values) {
                out.writeBlob(str);
            }
        }
    }

    @Override
    public int asof(Scalar value) {
        String target = value.getString();
        int start = 0;
        int end = this.values.length - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.values[mid].compareTo(target) <= 0) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return end;
    }
}

