/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.SymbolBase;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SymbolBaseCollection {
    private Map<Integer, SymbolBase> symbaseMap = new HashMap<Integer, SymbolBase>();
    private SymbolBase lastSymbase = null;

    public SymbolBase add(ExtendedDataInput in) throws IOException {
        int id = in.readInt();
        if (this.symbaseMap.containsKey(id)) {
            int size = in.readInt();
            if (size != 0) {
                throw new IOException("Invalid symbol base.");
            }
            this.lastSymbase = this.symbaseMap.get(id);
        } else {
            SymbolBase cur = new SymbolBase(id, in);
            this.symbaseMap.put(id, cur);
            this.lastSymbase = cur;
        }
        return this.lastSymbase;
    }

    public SymbolBase getLastSymbolBase() {
        return this.lastSymbase;
    }

    public void clear() {
        this.symbaseMap.clear();
        this.lastSymbase = null;
    }
}

