/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.BasicBooleanMatrix;
import com.xxdb.data.BasicBooleanVector;
import com.xxdb.data.BasicByte;
import com.xxdb.data.BasicByteMatrix;
import com.xxdb.data.BasicByteVector;
import com.xxdb.data.BasicChart;
import com.xxdb.data.BasicChunkMeta;
import com.xxdb.data.BasicDate;
import com.xxdb.data.BasicDateHour;
import com.xxdb.data.BasicDateHourMatrix;
import com.xxdb.data.BasicDateHourVector;
import com.xxdb.data.BasicDateMatrix;
import com.xxdb.data.BasicDateTime;
import com.xxdb.data.BasicDateTimeMatrix;
import com.xxdb.data.BasicDateTimeVector;
import com.xxdb.data.BasicDateVector;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicDouble;
import com.xxdb.data.BasicDoubleMatrix;
import com.xxdb.data.BasicDoubleVector;
import com.xxdb.data.BasicFloat;
import com.xxdb.data.BasicFloatMatrix;
import com.xxdb.data.BasicFloatVector;
import com.xxdb.data.BasicIPAddr;
import com.xxdb.data.BasicIPAddrVector;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicInt128;
import com.xxdb.data.BasicInt128Vector;
import com.xxdb.data.BasicIntMatrix;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicLong;
import com.xxdb.data.BasicLongMatrix;
import com.xxdb.data.BasicLongVector;
import com.xxdb.data.BasicMinute;
import com.xxdb.data.BasicMinuteMatrix;
import com.xxdb.data.BasicMinuteVector;
import com.xxdb.data.BasicMonth;
import com.xxdb.data.BasicMonthMatrix;
import com.xxdb.data.BasicMonthVector;
import com.xxdb.data.BasicNanoTime;
import com.xxdb.data.BasicNanoTimeMatrix;
import com.xxdb.data.BasicNanoTimeVector;
import com.xxdb.data.BasicNanoTimestamp;
import com.xxdb.data.BasicNanoTimestampMatrix;
import com.xxdb.data.BasicNanoTimestampVector;
import com.xxdb.data.BasicSecond;
import com.xxdb.data.BasicSecondMatrix;
import com.xxdb.data.BasicSecondVector;
import com.xxdb.data.BasicSet;
import com.xxdb.data.BasicShort;
import com.xxdb.data.BasicShortMatrix;
import com.xxdb.data.BasicShortVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringMatrix;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicSystemEntity;
import com.xxdb.data.BasicTable;
import com.xxdb.data.BasicTime;
import com.xxdb.data.BasicTimeMatrix;
import com.xxdb.data.BasicTimeVector;
import com.xxdb.data.BasicTimestamp;
import com.xxdb.data.BasicTimestampMatrix;
import com.xxdb.data.BasicTimestampVector;
import com.xxdb.data.BasicUuid;
import com.xxdb.data.BasicUuidVector;
import com.xxdb.data.Entity;
import com.xxdb.data.EntityFactory;
import com.xxdb.data.Matrix;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.data.Void;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;

public class BasicEntityFactory
implements EntityFactory {
    private TypeFactory[] factories = new TypeFactory[Entity.DATA_TYPE.values().length];
    private TypeFactory[] factoriesExt = new TypeFactory[Entity.DATA_TYPE.values().length];

    public BasicEntityFactory() {
        this.factories[Entity.DATA_TYPE.DT_BOOL.ordinal()] = new BooleanFactory();
        this.factories[Entity.DATA_TYPE.DT_BYTE.ordinal()] = new ByteFactory();
        this.factories[Entity.DATA_TYPE.DT_SHORT.ordinal()] = new ShortFactory();
        this.factories[Entity.DATA_TYPE.DT_INT.ordinal()] = new IntFactory();
        this.factories[Entity.DATA_TYPE.DT_LONG.ordinal()] = new LongFactory();
        this.factories[Entity.DATA_TYPE.DT_FLOAT.ordinal()] = new FloatFactory();
        this.factories[Entity.DATA_TYPE.DT_DOUBLE.ordinal()] = new DoubleFactory();
        this.factories[Entity.DATA_TYPE.DT_MINUTE.ordinal()] = new MinuteFactory();
        this.factories[Entity.DATA_TYPE.DT_SECOND.ordinal()] = new SecondFactory();
        this.factories[Entity.DATA_TYPE.DT_TIME.ordinal()] = new TimeFactory();
        this.factories[Entity.DATA_TYPE.DT_NANOTIME.ordinal()] = new NanoTimeFactory();
        this.factories[Entity.DATA_TYPE.DT_DATE.ordinal()] = new DateFactory();
        this.factories[Entity.DATA_TYPE.DT_DATEHOUR.ordinal()] = new DateHourFactory();
        this.factories[Entity.DATA_TYPE.DT_MONTH.ordinal()] = new MonthFactory();
        this.factories[Entity.DATA_TYPE.DT_DATETIME.ordinal()] = new DateTimeFactory();
        this.factories[Entity.DATA_TYPE.DT_TIMESTAMP.ordinal()] = new TimestampFactory();
        this.factories[Entity.DATA_TYPE.DT_NANOTIMESTAMP.ordinal()] = new NanoTimestampFactory();
        this.factories[Entity.DATA_TYPE.DT_SYMBOL.ordinal()] = new SymbolFactory();
        this.factories[Entity.DATA_TYPE.DT_STRING.ordinal()] = new StringFactory();
        this.factories[Entity.DATA_TYPE.DT_BLOB.ordinal()] = new BlobFactory();
        this.factories[Entity.DATA_TYPE.DT_FUNCTIONDEF.ordinal()] = new FunctionDefFactory();
        this.factories[Entity.DATA_TYPE.DT_HANDLE.ordinal()] = new SystemHandleFactory();
        this.factories[Entity.DATA_TYPE.DT_CODE.ordinal()] = new MetaCodeFactory();
        this.factories[Entity.DATA_TYPE.DT_DATASOURCE.ordinal()] = new DataSourceFactory();
        this.factories[Entity.DATA_TYPE.DT_RESOURCE.ordinal()] = new ResourceFactory();
        this.factories[Entity.DATA_TYPE.DT_COMPRESS.ordinal()] = new CompressFactory();
        this.factories[Entity.DATA_TYPE.DT_UUID.ordinal()] = new UuidFactory();
        this.factories[Entity.DATA_TYPE.DT_INT128.ordinal()] = new Int128Factory();
        this.factories[Entity.DATA_TYPE.DT_IPADDR.ordinal()] = new IPAddrFactory();
        this.factoriesExt[Entity.DATA_TYPE.DT_SYMBOL.ordinal()] = new ExtendedSymbolFactory();
    }

    @Override
    public Entity createEntity(Entity.DATA_FORM form, Entity.DATA_TYPE type, ExtendedDataInput in, boolean extended) throws IOException {
        if (form == Entity.DATA_FORM.DF_TABLE) {
            return new BasicTable(in);
        }
        if (form == Entity.DATA_FORM.DF_CHART) {
            return new BasicChart(in);
        }
        if (form == Entity.DATA_FORM.DF_DICTIONARY) {
            return new BasicDictionary(type, in);
        }
        if (form == Entity.DATA_FORM.DF_SET) {
            return new BasicSet(type, in);
        }
        if (form == Entity.DATA_FORM.DF_CHUNK) {
            return new BasicChunkMeta(in);
        }
        if (type == Entity.DATA_TYPE.DT_ANY && form == Entity.DATA_FORM.DF_VECTOR) {
            return new BasicAnyVector(in);
        }
        if (type == Entity.DATA_TYPE.DT_VOID && form == Entity.DATA_FORM.DF_SCALAR) {
            in.readBoolean();
            return new Void();
        }
        int index = type.ordinal();
        if (this.factories[index] == null) {
            throw new IOException("Data type " + type.name() + " is not supported yet.");
        }
        if (form == Entity.DATA_FORM.DF_VECTOR) {
            if (!extended) {
                return this.factories[index].createVector(in);
            }
            return this.factoriesExt[index].createVector(in);
        }
        if (form == Entity.DATA_FORM.DF_SCALAR) {
            return this.factories[index].createScalar(in);
        }
        if (form == Entity.DATA_FORM.DF_MATRIX) {
            return this.factories[index].createMatrix(in);
        }
        if (form == Entity.DATA_FORM.DF_PAIR) {
            return this.factories[index].createPair(in);
        }
        throw new IOException("Data form " + form.name() + " is not supported yet.");
    }

    @Override
    public Matrix createMatrixWithDefaultValue(Entity.DATA_TYPE type, int rows, int columns) {
        int index = type.ordinal();
        if (this.factories[index] == null) {
            return null;
        }
        return this.factories[index].createMatrixWithDefaultValue(rows, columns);
    }

    @Override
    public Vector createVectorWithDefaultValue(Entity.DATA_TYPE type, int size) {
        int index = type.ordinal();
        if (this.factories[index] == null) {
            return null;
        }
        return this.factories[index].createVectorWithDefaultValue(size);
    }

    @Override
    public Vector createPairWithDefaultValue(Entity.DATA_TYPE type) {
        int index = type.ordinal();
        if (this.factories[index] == null) {
            return null;
        }
        return this.factories[index].createPairWithDefaultValue();
    }

    @Override
    public Scalar createScalarWithDefaultValue(Entity.DATA_TYPE type) {
        int index = type.ordinal();
        if (this.factories[index] == null) {
            return null;
        }
        return this.factories[index].createScalarWithDefaultValue();
    }

    private class CompressFactory
    extends StringFactory {
        private CompressFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSystemEntity(in, Entity.DATA_TYPE.DT_COMPRESS);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicByteVector(Entity.DATA_FORM.DF_VECTOR, in);
        }
    }

    private class ResourceFactory
    extends StringFactory {
        private ResourceFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSystemEntity(in, Entity.DATA_TYPE.DT_RESOURCE);
        }
    }

    private class SystemHandleFactory
    extends StringFactory {
        private SystemHandleFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSystemEntity(in, Entity.DATA_TYPE.DT_HANDLE);
        }
    }

    private class DataSourceFactory
    extends StringFactory {
        private DataSourceFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSystemEntity(in, Entity.DATA_TYPE.DT_DATASOURCE);
        }
    }

    private class MetaCodeFactory
    extends StringFactory {
        private MetaCodeFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSystemEntity(in, Entity.DATA_TYPE.DT_CODE);
        }
    }

    private class FunctionDefFactory
    extends StringFactory {
        private FunctionDefFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSystemEntity(in, Entity.DATA_TYPE.DT_FUNCTIONDEF);
        }
    }

    private class BlobFactory
    implements TypeFactory {
        private BlobFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicString(in, true);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_VECTOR, in, false, true);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, in, false, true);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicStringMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicString("");
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicStringVector(Entity.DATA_FORM.DF_VECTOR, size, false, true);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, 2, false, true);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicStringMatrix(rows, columns);
        }
    }

    private class ExtendedSymbolFactory
    implements TypeFactory {
        private ExtendedSymbolFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicString(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_VECTOR, in, true, false);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, in, false, false);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicStringMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicString("");
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicStringVector(Entity.DATA_FORM.DF_VECTOR, size, true);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, 2, true);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicStringMatrix(rows, columns);
        }
    }

    private class SymbolFactory
    implements TypeFactory {
        private SymbolFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicString(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_VECTOR, in, false, false);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, in, false, false);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicStringMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicString("");
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicStringVector(Entity.DATA_FORM.DF_VECTOR, size, true);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, 2, true);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicStringMatrix(rows, columns);
        }
    }

    private class StringFactory
    implements TypeFactory {
        private StringFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicString(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_VECTOR, in, false, false);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, in, false, false);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicStringMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicString("");
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicStringVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicStringVector(Entity.DATA_FORM.DF_PAIR, 2, false);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicStringMatrix(rows, columns);
        }
    }

    private class IPAddrFactory
    implements TypeFactory {
        private IPAddrFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicIPAddr(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicIPAddrVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicIPAddrVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            throw new RuntimeException("Matrix for IPADDR not supported yet.");
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicIPAddr(0L, 0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicIPAddrVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicIPAddrVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            throw new RuntimeException("Matrix for IPADDR not supported yet.");
        }
    }

    private class UuidFactory
    implements TypeFactory {
        private UuidFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicUuid(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicUuidVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicUuidVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            throw new RuntimeException("Matrix for UUID not supported yet.");
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicUuid(0L, 0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicUuidVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicUuidVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            throw new RuntimeException("Matrix for UUID not supported yet.");
        }
    }

    private class Int128Factory
    implements TypeFactory {
        private Int128Factory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicInt128(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicInt128Vector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicInt128Vector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            throw new RuntimeException("Matrix for INT128 not supported yet.");
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicInt128(0L, 0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicInt128Vector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicInt128Vector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            throw new RuntimeException("Matrix for INT128 not supported yet.");
        }
    }

    private class NanoTimestampFactory
    implements TypeFactory {
        private NanoTimestampFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimestamp(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimestampVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimestampVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimestampMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicNanoTimestamp(0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicNanoTimestampVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicNanoTimestampVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicNanoTimestampMatrix(rows, columns);
        }
    }

    private class TimestampFactory
    implements TypeFactory {
        private TimestampFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicTimestamp(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicTimestampVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicTimestampVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicTimestampMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicTimestamp(0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicTimestampVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicTimestampVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicTimestampMatrix(rows, columns);
        }
    }

    private class DateTimeFactory
    implements TypeFactory {
        private DateTimeFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicDateTime(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicDateTimeVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicDateTimeVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicDateTimeMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicDateTime(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicDateTimeVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicDateTimeVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicDateTimeMatrix(rows, columns);
        }
    }

    private class MonthFactory
    implements TypeFactory {
        private MonthFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicMonth(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicMonthVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicMonthVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicMonthMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicMonth(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicMonthVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicMonthVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicMonthMatrix(rows, columns);
        }
    }

    private class DateHourFactory
    implements TypeFactory {
        private DateHourFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicDateHour(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicDateHourVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicDateHourVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicDateHourMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicDateHour(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicDateHourVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicDateHourVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicDateHourMatrix(rows, columns);
        }
    }

    private class DateFactory
    implements TypeFactory {
        private DateFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicDate(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicDateVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicDateVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicDateMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicDate(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicDateVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicDateVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicDateMatrix(rows, columns);
        }
    }

    private class NanoTimeFactory
    implements TypeFactory {
        private NanoTimeFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicNanoTime(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimeVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimeVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicNanoTimeMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicNanoTime(0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicNanoTimeVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicNanoTimeVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicNanoTimeMatrix(rows, columns);
        }
    }

    private class TimeFactory
    implements TypeFactory {
        private TimeFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicTime(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicTimeVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicTimeVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicTimeMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicTime(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicTimeVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicTimeVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicTimeMatrix(rows, columns);
        }
    }

    private class SecondFactory
    implements TypeFactory {
        private SecondFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicSecond(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicSecondVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicSecondVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicSecondMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicInt(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicSecondVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicSecondVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicSecondMatrix(rows, columns);
        }
    }

    private class MinuteFactory
    implements TypeFactory {
        private MinuteFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicMinute(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicMinuteVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicMinuteVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicMinuteMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicMinute(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicMinuteVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicMinuteVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicMinuteMatrix(rows, columns);
        }
    }

    private class DoubleFactory
    implements TypeFactory {
        private DoubleFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicDouble(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicDoubleVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicDoubleVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicDoubleMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicDouble(0.0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicDoubleVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicDoubleVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicDoubleMatrix(rows, columns);
        }
    }

    private class FloatFactory
    implements TypeFactory {
        private FloatFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicFloat(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicFloatVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicFloatVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicFloatMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicFloat(0.0f);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicFloatVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicFloatVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicFloatMatrix(rows, columns);
        }
    }

    private class LongFactory
    implements TypeFactory {
        private LongFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicLong(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicLongVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicLongVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicLongMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicLong(0L);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicLongVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicLongVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicLongMatrix(rows, columns);
        }
    }

    private class IntFactory
    implements TypeFactory {
        private IntFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicInt(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicIntVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicIntVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicIntMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicInt(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicIntVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicIntVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicIntMatrix(rows, columns);
        }
    }

    private class ShortFactory
    implements TypeFactory {
        private ShortFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicShort(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicShortVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicShortVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicShortMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicShort(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicShortVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicShortVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicShortMatrix(rows, columns);
        }
    }

    private class ByteFactory
    implements TypeFactory {
        private ByteFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicByte(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicByteVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicByteVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicByteMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicByte(0);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicByteVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicByteVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicByteMatrix(rows, columns);
        }
    }

    private class BooleanFactory
    implements TypeFactory {
        private BooleanFactory() {
        }

        @Override
        public Scalar createScalar(ExtendedDataInput in) throws IOException {
            return new BasicBoolean(in);
        }

        @Override
        public Vector createVector(ExtendedDataInput in) throws IOException {
            return new BasicBooleanVector(Entity.DATA_FORM.DF_VECTOR, in);
        }

        @Override
        public Vector createPair(ExtendedDataInput in) throws IOException {
            return new BasicBooleanVector(Entity.DATA_FORM.DF_PAIR, in);
        }

        @Override
        public Matrix createMatrix(ExtendedDataInput in) throws IOException {
            return new BasicBooleanMatrix(in);
        }

        @Override
        public Scalar createScalarWithDefaultValue() {
            return new BasicBoolean(false);
        }

        @Override
        public Vector createVectorWithDefaultValue(int size) {
            return new BasicBooleanVector(size);
        }

        @Override
        public Vector createPairWithDefaultValue() {
            return new BasicBooleanVector(Entity.DATA_FORM.DF_PAIR, 2);
        }

        @Override
        public Matrix createMatrixWithDefaultValue(int rows, int columns) {
            return new BasicBooleanMatrix(rows, columns);
        }
    }

    private static interface TypeFactory {
        public Scalar createScalar(ExtendedDataInput var1) throws IOException;

        public Vector createVector(ExtendedDataInput var1) throws IOException;

        public Vector createPair(ExtendedDataInput var1) throws IOException;

        public Matrix createMatrix(ExtendedDataInput var1) throws IOException;

        public Scalar createScalarWithDefaultValue();

        public Vector createVectorWithDefaultValue(int var1);

        public Vector createPairWithDefaultValue();

        public Matrix createMatrixWithDefaultValue(int var1, int var2);
    }
}

