/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.BasicDBTask;
import com.xxdb.DBConnection;
import com.xxdb.DBConnectionPool;
import com.xxdb.DBTask;
import com.xxdb.ExclusiveDBConnectionPool;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Table;
import com.xxdb.data.Vector;
import com.xxdb.route.Domain;
import com.xxdb.route.DomainFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PartitionedTableAppender {
    private BasicDictionary tableInfo;
    private Domain domain;
    private int partitionColumnIdx;
    private int cols;
    private Entity.DATA_CATEGORY[] columnCategories;
    private Entity.DATA_TYPE[] columnTypes;
    private int threadCount;
    private DBConnectionPool pool;
    private List<ArrayList<Integer>> chunkIndices;
    private String appendScript;

    public PartitionedTableAppender(String dbUrl, String tableName, String partitionColName, DBConnectionPool pool) throws Exception {
        this(dbUrl, tableName, partitionColName, null, pool);
    }

    public PartitionedTableAppender(String dbUrl, String tableName, String partitionColName, String appendFunction, DBConnectionPool pool) throws Exception {
        this.pool = pool;
        this.threadCount = pool.getConnectionCount();
        this.chunkIndices = new ArrayList<ArrayList<Integer>>(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            this.chunkIndices.add(new ArrayList());
        }
        try (DBConnection conn = new DBConnection();){
            Entity.DATA_TYPE partitionColType;
            int partitionType;
            Entity partitionSchema;
            BasicDBTask task;
            if (dbUrl == null || dbUrl.isEmpty()) {
                task = new BasicDBTask("schema(" + tableName + ")");
                this.appendScript = "tableInsert{" + tableName + "}";
            } else {
                task = new BasicDBTask("schema(loadTable(\"" + dbUrl + "\", \"" + tableName + "\"))");
                this.appendScript = "tableInsert{loadTable('" + dbUrl + "', '" + tableName + "')}";
            }
            if (appendFunction != null && !appendFunction.isEmpty()) {
                this.appendScript = appendFunction;
            }
            pool.execute(task);
            if (!task.isSuccessful()) {
                throw new RuntimeException(task.getErrorMsg());
            }
            this.tableInfo = (BasicDictionary)task.getResult();
            Entity partColNames = this.tableInfo.get(new BasicString("partitionColumnName"));
            if (partColNames == null) {
                throw new RuntimeException("Can't find specified partition column name.");
            }
            if (partColNames.isScalar()) {
                if (!((BasicString)partColNames).getString().equalsIgnoreCase(partitionColName)) {
                    throw new RuntimeException("Can't find specified partition column name.");
                }
                this.partitionColumnIdx = ((BasicInt)this.tableInfo.get(new BasicString("partitionColumnIndex"))).getInt();
                partitionSchema = this.tableInfo.get(new BasicString("partitionSchema"));
                partitionType = ((BasicInt)this.tableInfo.get(new BasicString("partitionType"))).getInt();
                partitionColType = Entity.DATA_TYPE.values()[((BasicInt)this.tableInfo.get(new BasicString("partitionColumnType"))).getInt()];
            } else {
                BasicStringVector vec = (BasicStringVector)partColNames;
                int dims = vec.rows();
                int index = -1;
                for (int i = 0; i < dims; ++i) {
                    if (!vec.getString(i).equalsIgnoreCase(partitionColName)) continue;
                    index = i;
                    break;
                }
                if (index < 0) {
                    throw new RuntimeException("Can't find specified partition column name.");
                }
                this.partitionColumnIdx = ((BasicIntVector)this.tableInfo.get(new BasicString("partitionColumnIndex"))).getInt(index);
                partitionSchema = ((BasicAnyVector)this.tableInfo.get(new BasicString("partitionSchema"))).getEntity(index);
                partitionType = ((BasicIntVector)this.tableInfo.get(new BasicString("partitionType"))).getInt(index);
                partitionColType = Entity.DATA_TYPE.values()[((BasicIntVector)this.tableInfo.get(new BasicString("partitionColumnType"))).getInt(index)];
            }
            BasicTable colDefs = (BasicTable)this.tableInfo.get(new BasicString("colDefs"));
            this.cols = colDefs.getColumn(0).rows();
            BasicIntVector typeInts = (BasicIntVector)colDefs.getColumn("typeInt");
            this.columnCategories = new Entity.DATA_CATEGORY[this.cols];
            this.columnTypes = new Entity.DATA_TYPE[this.cols];
            for (int i = 0; i < this.cols; ++i) {
                this.columnTypes[i] = Entity.DATA_TYPE.values()[typeInts.getInt(i)];
                this.columnCategories[i] = Entity.typeToCategory(this.columnTypes[i]);
            }
            this.domain = DomainFactory.createDomain(Entity.PARTITION_TYPE.values()[partitionType], partitionColType, partitionSchema);
        }
    }

    public int append(Table table) throws IOException {
        int i;
        if (this.cols != table.columns()) {
            throw new RuntimeException("The input table doesn't match the schema of the target table.");
        }
        for (i = 0; i < this.cols; ++i) {
            Vector curCol = table.getColumn(i);
            this.checkColumnType(i, curCol.getDataCategory(), curCol.getDataType());
        }
        for (i = 0; i < this.threadCount; ++i) {
            this.chunkIndices.get(i).clear();
        }
        List<Integer> keys = this.domain.getPartitionKeys(table.getColumn(this.partitionColumnIdx));
        int rows = keys.size();
        for (int i2 = 0; i2 < rows; ++i2) {
            int key = keys.get(i2);
            if (key < 0) continue;
            this.chunkIndices.get(key % this.threadCount).add(i2);
        }
        ArrayList<DBTask> tasks = new ArrayList<DBTask>(this.threadCount);
        for (int i3 = 0; i3 < this.threadCount; ++i3) {
            ArrayList<Integer> chunk = this.chunkIndices.get(i3);
            if (chunk.isEmpty()) continue;
            int count = chunk.size();
            int[] array = new int[count];
            for (int j = 0; j < count; ++j) {
                array[j] = chunk.get(j);
            }
            Table subTable = table.getSubTable(array);
            ArrayList<Entity> args = new ArrayList<Entity>(1);
            args.add(subTable);
            tasks.add(new BasicDBTask(this.appendScript, args));
        }
        this.pool.execute(tasks);
        int affected = 0;
        for (int i4 = 0; i4 < tasks.size(); ++i4) {
            DBTask task = (DBTask)tasks.get(i4);
            if (!task.isSuccessful()) continue;
            Entity re = task.getResult();
            if (re.getDataType() == Entity.DATA_TYPE.DT_VOID) {
                affected = 0;
                continue;
            }
            affected += ((BasicInt)task.getResult()).getInt();
        }
        return affected;
    }

    private void checkColumnType(int col, Entity.DATA_CATEGORY category, Entity.DATA_TYPE type) {
        Entity.DATA_CATEGORY expectCategory = this.columnCategories[col];
        Entity.DATA_TYPE expectType = this.columnTypes[col];
        if (category != expectCategory) {
            throw new RuntimeException("column " + col + ", expect category " + expectCategory.name() + ", got category " + category.name());
        }
        if (category == Entity.DATA_CATEGORY.TEMPORAL && type != expectType) {
            throw new RuntimeException("column " + col + ", temporal column must have exactly the same type, expect " + expectType.name() + ", got " + type.name());
        }
    }

    public static void main(String[] args) {
        try {
            ExclusiveDBConnectionPool pool = new ExclusiveDBConnectionPool("localhost", 8801, "admin", "123456", 5, true, true);
            PartitionedTableAppender appender = new PartitionedTableAppender("dfs://demohash", "pt", "id", pool);
            ArrayList<String> colNames = new ArrayList<String>(2);
            colNames.add("id");
            colNames.add("value");
            ArrayList<Vector> cols = new ArrayList<Vector>(2);
            BasicStringVector id = new BasicStringVector(3);
            id.setString(0, "ORCA");
            id.setString(1, "YHOO");
            id.setString(2, "Ford");
            cols.add(id);
            BasicIntVector value = new BasicIntVector(3);
            value.setInt(0, 10);
            value.setInt(1, 11);
            value.setInt(2, 12);
            cols.add(value);
            appender.append(new BasicTable(colNames, cols));
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }
}

