/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import com.xxdb.DBConnection;
import com.xxdb.DBConnectionPool;
import com.xxdb.DBTask;
import com.xxdb.data.BasicStringVector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExclusiveDBConnectionPool
implements DBConnectionPool {
    private List<DBConnection> conns;
    private ExecutorService executor;

    public ExclusiveDBConnectionPool(String host, int port, String uid, String pwd, int count, boolean loadBalance, boolean highAvailability) throws IOException {
        this.conns = new ArrayList<DBConnection>(count);
        if (!loadBalance) {
            for (int i = 0; i < count; ++i) {
                DBConnection conn = new DBConnection();
                if (!conn.connect(host, port, uid, pwd, highAvailability)) {
                    throw new RuntimeException("Can't connect to the specified host.");
                }
                this.conns.add(conn);
            }
        } else {
            int i;
            DBConnection entryPoint = new DBConnection();
            if (!entryPoint.connect(host, port, uid, pwd)) {
                throw new RuntimeException("Can't connect to the specified host.");
            }
            BasicStringVector nodes = (BasicStringVector)entryPoint.run("rpc(getControllerAlias(), getClusterLiveDataNodes{false})");
            int nodeCount = nodes.rows();
            String[] hosts = new String[nodeCount];
            int[] ports = new int[nodeCount];
            for (i = 0; i < nodeCount; ++i) {
                String[] fields = nodes.getString(i).split(":");
                if (fields.length < 2) {
                    throw new RuntimeException("Invalid data node address: " + nodes.getString(i));
                }
                hosts[i] = fields[0];
                ports[i] = Integer.parseInt(fields[1]);
            }
            for (i = 0; i < count; ++i) {
                DBConnection conn = new DBConnection();
                if (!conn.connect(hosts[i % nodeCount], ports[i % nodeCount], uid, pwd, highAvailability)) {
                    throw new RuntimeException("Can't connect to the host " + nodes.getString(i));
                }
                this.conns.add(conn);
            }
        }
        this.executor = Executors.newFixedThreadPool(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(List<DBTask> tasks) {
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            try {
                int taskCount = tasks.size();
                if (taskCount > this.conns.size()) {
                    throw new RuntimeException("The number of tasks can't exceed the number of connections in the pool.");
                }
                for (int i = 0; i < taskCount; ++i) {
                    tasks.get(i).setDBConnection(this.conns.get(i));
                }
                List futures = this.executor.invokeAll(tasks);
                for (int i = 0; i < taskCount; ++i) {
                    futures.get(i).get();
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (ExecutionException ie) {
                throw new RuntimeException(ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(DBTask task) {
        try {
            ExecutorService executorService = this.executor;
            synchronized (executorService) {
                task.setDBConnection(this.conns.get(0));
                task.call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getConnectionCount() {
        return this.conns.size();
    }

    @Override
    public void shutdown() {
        try {
            this.executor.shutdown();
            for (int i = 0; i < this.conns.size(); ++i) {
                this.conns.get(i).close();
            }
            this.conns.clear();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

