/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import com.xxdb.compression.DeltaOfDeltaBlockEncoder;
import com.xxdb.compression.Encoder;
import com.xxdb.data.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DeltaOfDeltaEncoder
implements Encoder {
    private static final int DEFAULT_BLOCK_SIZE = 65536;

    @Override
    public List<Object> compress(ByteBuffer in, int elementCount, int unitLength, int maxCompressedLength, ByteBuffer out) throws IOException {
        DeltaOfDeltaBlockEncoder blockEncoder = new DeltaOfDeltaBlockEncoder(unitLength);
        int count = 0;
        while (elementCount > 0) {
            int blockSize = Math.min(elementCount * unitLength, 65536);
            long[] compressed = blockEncoder.compress(in, blockSize);
            out.putInt(compressed.length * 8);
            for (long l : compressed) {
                while (8 + out.position() > out.limit()) {
                    out = Utils.reAllocByteBuffer(out, Math.max(out.capacity() * 2, 1024));
                }
                out.putLong(l);
            }
            count += 4 + compressed.length * 8;
            elementCount -= blockSize / unitLength;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(count);
        ret.add(out);
        return ret;
    }

    public ByteBuffer compress(ByteBuffer in, int elementCount, int unitLength, int maxCompressedLength) throws IOException {
        int blockSize;
        long[] compressed;
        DeltaOfDeltaBlockEncoder blockEncoder = new DeltaOfDeltaBlockEncoder(unitLength);
        ByteBuffer out = ByteBuffer.allocate(maxCompressedLength);
        for (int count = 0; elementCount > 0 && count < maxCompressedLength; count += 4 + compressed.length * 8, elementCount -= blockSize / unitLength) {
            blockSize = Math.min(elementCount * unitLength, 65536);
            compressed = blockEncoder.compress(in, blockSize);
            out.putInt(compressed.length * 8);
            for (long l : compressed) {
                out.putLong(l);
            }
        }
        return out;
    }
}

