/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import com.xxdb.compression.DecoderFactory;
import com.xxdb.data.Entity;
import com.xxdb.data.EntityFactory;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;

public class VectorDecompressor {
    public Vector decompress(EntityFactory factory, ExtendedDataInput in, boolean extended, boolean isLittleEndian) throws IOException {
        int compressedBytes = in.readInt();
        in.skipBytes(7);
        byte compression = in.readByte();
        byte dataType = in.readByte();
        byte unitLength = in.readByte();
        in.skipBytes(6);
        int elementCount = in.readInt();
        in.readInt();
        ExtendedDataInput decompressedIn = DecoderFactory.get(compression).decompress(in, compressedBytes - 20, unitLength, elementCount, isLittleEndian);
        Entity.DATA_TYPE dt = Entity.DATA_TYPE.valueOf(dataType);
        return (Vector)factory.createEntity(Entity.DATA_FORM.DF_VECTOR, dt, decompressedIn, extended);
    }
}

