/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.compression.EncoderFactory;
import com.xxdb.data.AbstractEntity;
import com.xxdb.data.BasicSymbolVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public abstract class AbstractVector
extends AbstractEntity
implements Vector {
    private Entity.DATA_FORM df_;
    protected static final int BUF_SIZE = 4096;
    protected byte[] buf = new byte[4096];
    protected int compressedMethod = 1;

    protected abstract void writeVectorToOutputStream(ExtendedDataOutput var1) throws IOException;

    public AbstractVector(Entity.DATA_FORM df) {
        this.df_ = df;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        throw new RuntimeException("Vector.deserialize not implemented yet.");
    }

    @Override
    public Entity.DATA_FORM getDataForm() {
        return this.df_;
    }

    @Override
    public int columns() {
        return 1;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return -1;
    }

    @Override
    public String getString(int index) {
        return this.get(index).getString();
    }

    @Override
    public String getString() {
        StringBuilder sb = new StringBuilder("[");
        int size = Math.min(10, this.rows());
        if (size > 0) {
            sb.append(this.getString(0));
        }
        for (int i = 1; i < size; ++i) {
            sb.append(',');
            sb.append(this.getString(i));
        }
        if (size < this.rows()) {
            sb.append(",...");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(ExtendedDataOutput out) throws IOException {
        int dataType = this.getDataType().getValue();
        if (this instanceof BasicSymbolVector) {
            dataType += 128;
        }
        int flag = (this.df_.ordinal() << 8) + dataType;
        out.writeShort(flag);
        out.writeInt(this.rows());
        out.writeInt(this.columns());
        this.writeVectorToOutputStream(out);
    }

    public void setCompressedMethod(int method) {
        Entity.DATA_TYPE type = this.getDataType();
        switch (type) {
            case DT_STRING: 
            case DT_BOOL: 
            case DT_BYTE: 
            case DT_SHORT: 
            case DT_INT: 
            case DT_DATE: 
            case DT_MONTH: 
            case DT_TIME: 
            case DT_MINUTE: 
            case DT_SECOND: 
            case DT_DATETIME: 
            case DT_DATEHOUR: 
            case DT_DATEMINUTE: 
            case DT_SYMBOL: 
            case DT_LONG: 
            case DT_NANOTIME: 
            case DT_TIMESTAMP: 
            case DT_NANOTIMESTAMP: 
            case DT_INT128: 
            case DT_UUID: 
            case DT_IPADDR: 
            case DT_POINT: {
                break;
            }
            case DT_FLOAT: 
            case DT_DOUBLE: 
            case DT_COMPLEX: 
            case DT_DURATION: {
                if (method == 1) break;
            }
            default: {
                throw new RuntimeException("Compression Failed: only support integral and temporal data, not support " + this.getDataType().name());
            }
        }
        this.compressedMethod = method;
    }

    protected ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        throw new RuntimeException("Invalid datatype to write to buffer");
    }

    public static int getUnitLength(Entity.DATA_TYPE type) {
        int unitLength = 0;
        switch (type) {
            case DT_STRING: {
                unitLength = 0;
                break;
            }
            case DT_BOOL: 
            case DT_BYTE: {
                unitLength = 1;
                break;
            }
            case DT_SHORT: {
                unitLength = 2;
                break;
            }
            case DT_INT: 
            case DT_DATE: 
            case DT_MONTH: 
            case DT_TIME: 
            case DT_MINUTE: 
            case DT_SECOND: 
            case DT_DATETIME: 
            case DT_DATEHOUR: 
            case DT_DATEMINUTE: 
            case DT_SYMBOL: 
            case DT_FLOAT: {
                unitLength = 4;
                break;
            }
            case DT_LONG: 
            case DT_NANOTIME: 
            case DT_TIMESTAMP: 
            case DT_NANOTIMESTAMP: 
            case DT_DOUBLE: 
            case DT_DURATION: {
                unitLength = 8;
                break;
            }
            case DT_INT128: 
            case DT_UUID: 
            case DT_IPADDR: 
            case DT_POINT: 
            case DT_COMPLEX: {
                unitLength = 16;
                break;
            }
            default: {
                throw new RuntimeException("Compression Failed: only support integral and temporal data, not support " + type.name());
            }
        }
        return unitLength;
    }

    @Override
    public void writeCompressed(ExtendedDataOutput output) throws IOException {
        int dataType = this.getDataType().getValue();
        int unitLength = AbstractVector.getUnitLength(this.getDataType());
        int elementCount = this.rows();
        int maxCompressedLength = this.rows() * 8 * 2 + 192;
        ByteBuffer out = output instanceof LittleEndianDataOutputStream ? ByteBuffer.allocate(Math.max(elementCount * unitLength, 655360)).order(ByteOrder.LITTLE_ENDIAN) : ByteBuffer.allocate(Math.max(elementCount * unitLength, 655360)).order(ByteOrder.BIG_ENDIAN);
        short flag = (short)(Entity.DATA_FORM.DF_VECTOR.ordinal() << 8 | Entity.DATA_TYPE.DT_COMPRESS.getValue() & 0xFF);
        out.putShort(flag);
        out.putInt(0);
        out.putInt(1);
        out.put((byte)0);
        out.put((byte)1);
        out.put((byte)-1);
        out.put((byte)this.compressedMethod);
        out.put((byte)dataType);
        out.put((byte)unitLength);
        out.position(out.position() + 2);
        out.putInt(-1);
        out.putInt(elementCount);
        out.putInt(-1);
        ByteBuffer in = output instanceof LittleEndianDataOutputStream ? ByteBuffer.allocate(Math.max(elementCount * unitLength, 655360)).order(ByteOrder.LITTLE_ENDIAN) : ByteBuffer.allocate(Math.max(elementCount * unitLength, 655360)).order(ByteOrder.BIG_ENDIAN);
        in = this.writeVectorToBuffer(in);
        in.flip();
        List<Object> ret = EncoderFactory.get(this.compressedMethod).compress(in, elementCount, unitLength, maxCompressedLength, out);
        int compressedLength = 20 + (Integer)ret.get(0);
        out = (ByteBuffer)ret.get(1);
        out.putInt(2, compressedLength);
        output.write(out.array(), 0, compressedLength + 10);
    }
}

