/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicString;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BasicArrayVector
extends AbstractVector {
    private Entity.DATA_TYPE type;
    private int[] rowIndices;
    private Vector valueVec;

    public BasicArrayVector(Entity.DATA_TYPE type, ExtendedDataInput in) throws IOException {
        super(Entity.DATA_FORM.DF_VECTOR);
        int rows = in.readInt();
        int cols = in.readInt();
        this.rowIndices = new int[rows];
        Entity.DATA_TYPE valueType = Entity.DATA_TYPE.valueOf(type.getValue() - 64);
        this.valueVec = BasicEntityFactory.instance().createVectorWithDefaultValue(valueType, cols);
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        int rowsReadInBlock = 0;
        int prevIndex = 0;
        int totalBytes = 0;
        for (int rowsRead = 0; rowsRead < rows; rowsRead += rowsReadInBlock) {
            int len;
            int blockRows = in.readUnsignedShort();
            int countBytes = in.readUnsignedByte();
            in.skipBytes(1);
            totalBytes = blockRows * countBytes;
            rowsReadInBlock = 0;
            for (int offset = 0; offset < totalBytes; offset += len) {
                int curRowCells;
                int i;
                len = Math.min(4096, totalBytes - offset);
                in.readFully(this.buf, 0, len);
                int curRows = len / countBytes;
                if (countBytes == 1) {
                    for (int i2 = 0; i2 < curRows; ++i2) {
                        int curRowCells2 = Byte.toUnsignedInt(this.buf[i2]);
                        this.rowIndices[rowsRead + rowsReadInBlock + i2] = prevIndex + curRowCells2;
                        prevIndex += curRowCells2;
                    }
                } else if (countBytes == 2) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
                    for (i = 0; i < curRows; ++i) {
                        curRowCells = Short.toUnsignedInt(byteBuffer.getShort(i * 2));
                        this.rowIndices[rowsRead + rowsReadInBlock + i] = prevIndex + curRowCells;
                        prevIndex += curRowCells;
                    }
                } else {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
                    for (i = 0; i < curRows; ++i) {
                        curRowCells = byteBuffer.getInt(i * 4);
                        this.rowIndices[rowsRead + rowsReadInBlock + i] = prevIndex + curRowCells;
                        prevIndex += curRowCells;
                    }
                }
                rowsReadInBlock += curRows;
            }
            int rowStart = rowsRead == 0 ? 0 : this.rowIndices[rowsRead - 1];
            int valueCount = this.rowIndices[rowsRead + rowsReadInBlock - 1] - rowStart;
            this.valueVec.deserialize(rowStart, valueCount, in);
        }
    }

    @Override
    public String getString(int index) {
        StringBuilder sb = new StringBuilder("[");
        int startPosValueVec = index == 0 ? 0 : this.rowIndices[index - 1];
        int rows = this.rowIndices[index] - startPosValueVec;
        int size = Math.min(3, rows);
        if (size > 0) {
            sb.append(this.valueVec.getString(startPosValueVec));
        }
        for (int i = 1; i < size; ++i) {
            sb.append(',');
            sb.append(this.valueVec.getString(startPosValueVec + i));
        }
        if (size < rows) {
            sb.append(",...");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Vector combine(Vector vector) {
        return null;
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return null;
    }

    @Override
    public int asof(Scalar value) {
        return 0;
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public void setNull(int index) {
    }

    @Override
    public Scalar get(int index) {
        return new BasicString(this.getString(index));
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
    }

    @Override
    public Class<?> getElementClass() {
        return Entity.class;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.ARRAY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return this.type;
    }

    @Override
    public int rows() {
        return this.rowIndices.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
    }
}

