/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicDateTime;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.util.List;

public class BasicDateTimeVector
extends BasicIntVector {
    public BasicDateTimeVector(int size) {
        super(size);
    }

    public BasicDateTimeVector(List<Integer> list) {
        super(list);
    }

    public BasicDateTimeVector(int[] array) {
        super(array);
    }

    protected BasicDateTimeVector(int[] array, boolean copy) {
        super(array, copy);
    }

    protected BasicDateTimeVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicDateTimeVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DATETIME;
    }

    @Override
    public Scalar get(int index) {
        return new BasicDateTime(this.getInt(index));
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return new BasicDateTimeVector(this.getSubArray(indices), false);
    }

    public LocalDateTime getDateTime(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseDateTime(this.getInt(index));
    }

    public void setDateTime(int index, LocalDateTime dt) {
        this.setInt(index, Utils.countSeconds(dt));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDateTime.class;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicDateTimeVector v = (BasicDateTimeVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicDateTimeVector(newValue);
    }

    @Override
    protected ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        for (int val : this.values) {
            buffer.putInt(val);
        }
        return buffer;
    }
}

