/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.time.temporal.Temporal;

public class BasicDuration
extends AbstractScalar
implements Comparable<BasicDuration> {
    private static final String[] unitSyms = new String[]{"ns", "us", "ms", "s", "m", "H", "d", "w", "M", "y", "B"};
    private int value;
    private Entity.DURATION unit;

    public BasicDuration(Entity.DURATION unit, int value) {
        this.value = value;
        this.unit = unit;
    }

    public BasicDuration(ExtendedDataInput in) throws IOException {
        this.value = in.readInt();
        this.unit = Entity.DURATION.values()[in.readInt()];
    }

    public int getDuration() {
        return this.value;
    }

    public Entity.DURATION getUnit() {
        return this.unit;
    }

    @Override
    public boolean isNull() {
        return this.value == Integer.MIN_VALUE;
    }

    @Override
    public void setNull() {
        this.value = Integer.MIN_VALUE;
    }

    @Override
    public Number getNumber() throws Exception {
        return new Integer(this.value);
    }

    @Override
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public int hashBucket(int buckets) {
        return 0;
    }

    @Override
    public String getJsonString() {
        return this.getString();
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.SYSTEM;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DURATION;
    }

    @Override
    public String getString() {
        if (this.value == Integer.MIN_VALUE) {
            return "";
        }
        return String.valueOf(this.value) + unitSyms[this.unit.ordinal()];
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeInt(this.value);
        out.writeInt(this.unit.ordinal());
    }

    @Override
    public int compareTo(BasicDuration o) {
        if (this.unit == o.unit) {
            return Integer.compare(o.value, this.value);
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicDuration) || o == null) {
            return false;
        }
        return this.value == ((BasicDuration)o).value && this.unit == ((BasicDuration)o).unit;
    }
}

