/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicDuration;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BasicDurationVector
extends AbstractVector {
    private int[] values;

    public BasicDurationVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    protected BasicDurationVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new int[2 * size];
    }

    protected BasicDurationVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        ByteOrder bo;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols * 2;
        this.values = new int[size];
        int totalBytes = size * 4;
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = off / 4;
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getInt(i * 4);
            }
        }
    }

    @Override
    public Scalar get(int index) {
        int unitIndex = this.values[2 * index + 1];
        if (unitIndex == Integer.MIN_VALUE) {
            return new BasicDuration(Entity.DURATION.NS, Integer.MIN_VALUE);
        }
        return new BasicDuration(Entity.DURATION.values()[this.values[2 * index + 1]], this.values[2 * index]);
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        BasicDuration duration = (BasicDuration)value;
        this.values[2 * index] = duration.getDuration();
        this.values[2 * index + 1] = duration.getUnit().ordinal();
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return 0;
    }

    @Override
    public Vector combine(Vector vector) {
        throw new RuntimeException("BasicDurationVector.combine not implemented yet.");
    }

    @Override
    public boolean isNull(int index) {
        return this.values[2 * index + 1] == Integer.MIN_VALUE || this.values[2 * index] == Integer.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.values[2 * index] = 0;
        this.values[2 * index + 1] = Integer.MIN_VALUE;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.SYSTEM;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DURATION;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDuration.class;
    }

    @Override
    public int rows() {
        return this.values.length / 2;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeIntArray(this.values);
    }

    @Override
    protected ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        for (int val : this.values) {
            buffer.putInt(val);
        }
        return buffer;
    }

    @Override
    public int asof(Scalar value) {
        throw new RuntimeException("BasicDurationVector.asof not implemented yet.");
    }

    @Override
    public Vector getSubVector(int[] indices) {
        throw new RuntimeException("BasicDurationVector.getSubVector not implemented yet.");
    }
}

