/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicFloat;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BasicFloatVector
extends AbstractVector {
    private float[] values;

    public BasicFloatVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicFloatVector(List<Float> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i).floatValue();
            }
        }
    }

    public BasicFloatVector(float[] array) {
        this(array, true);
    }

    public BasicFloatVector(float[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (float[])array.clone() : array;
    }

    protected BasicFloatVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new float[size];
    }

    protected BasicFloatVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        ByteOrder bo;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new float[size];
        int totalBytes = size * 4;
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = off / 4;
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getFloat(i * 4);
            }
        }
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        ByteOrder bo;
        int totalBytes = count * 4;
        int off = 0;
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        while (off < totalBytes) {
            int len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getFloat(i * 4);
            }
            off += len;
            start += end;
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicFloat(this.values[index]);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        float[] sub = new float[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicFloatVector(sub, false);
    }

    public float getFloat(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index] = value.isNull() ? -3.4028235E38f : value.getNumber().floatValue();
    }

    public void setFloat(int index, float value) {
        this.values[index] = value;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicFloatVector v = (BasicFloatVector)vector;
        int newSize = this.rows() + v.rows();
        float[] newValue = new float[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicFloatVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == -3.4028235E38f;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = -3.4028235E38f;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.FLOATING;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_FLOAT;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicFloat.class;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeFloatArray(this.values);
    }

    @Override
    protected ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        for (float val : this.values) {
            buffer.putFloat(val);
        }
        return buffer;
    }

    @Override
    public int asof(Scalar value) {
        float target;
        try {
            target = value.getNumber().floatValue();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        int start = 0;
        int end = this.values.length - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.values[mid] <= target) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return end;
    }
}

