/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicInt;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BasicIntVector
extends AbstractVector {
    protected int[] values;

    public BasicIntVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicIntVector(List<Integer> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i);
            }
        }
    }

    public BasicIntVector(int[] array) {
        this(array, true);
    }

    public BasicIntVector(int[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (int[])array.clone() : array;
    }

    protected BasicIntVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new int[size];
    }

    protected BasicIntVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        ByteOrder bo;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new int[size];
        int totalBytes = size * 4;
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = off / 4;
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getInt(i * 4);
            }
        }
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        ByteOrder bo;
        int totalBytes = count * 4;
        int off = 0;
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        while (off < totalBytes) {
            int len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getInt(i * 4);
            }
            off += len;
            start += end;
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicInt(this.values[index]);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        int[] sub = new int[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicIntVector(sub, false);
    }

    protected int[] getSubArray(int[] indices) {
        int length = indices.length;
        int[] sub = new int[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return sub;
    }

    public int getInt(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index] = value.isNull() ? Integer.MIN_VALUE : value.getNumber().intValue();
    }

    public void setInt(int index, int value) {
        this.values[index] = value;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        int value = this.values[index];
        if (value >= 0) {
            return value % buckets;
        }
        if (value == Integer.MIN_VALUE) {
            return -1;
        }
        return (int)((0x100000000L + (long)value) % (long)buckets);
    }

    @Override
    public Vector combine(Vector vector) {
        BasicIntVector v = (BasicIntVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicIntVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == Integer.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = Integer.MIN_VALUE;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_INT;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicInt.class;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeIntArray(this.values);
    }

    @Override
    protected ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        for (int val : this.values) {
            buffer.putInt(val);
        }
        return buffer;
    }

    @Override
    public int asof(Scalar value) {
        int target;
        try {
            target = value.getNumber().intValue();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        int start = 0;
        int end = this.values.length - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.values[mid] <= target) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return end;
    }
}

